/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.fx;

import java.awt.Rectangle;
import java.awt.SplashScreen;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import jp.co.extreme.app.common.AfbApplicationEvent;
import jp.co.extreme.app.common.AfbApplicationEventHandler;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.scf4.swg.HswgLafHelper;
import jp.co.extreme.swing.SwgxDesktopBase;

public class IfxSplashScreenPane
implements AfbApplicationEventHandler {
    protected int labelHeigt = 20;
    protected int pading = 2;
    boolean isOpacity = true;
    protected FxLabel label;
    protected Stage stage;

    @Override
    public void actionPerformed(AfbApplicationEvent ev) throws Exception {
        if (ev.type == 11) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IfxSplashScreenPane.this.setupStarted();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        } else if (ev.type == 41) {
            final String text = BcStringUtil.toStringNotNull(ev.value);
            if (!BcStringUtil.isEmpty(text)) {
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IfxSplashScreenPane.this.drawText(text);
                        }
                        catch (Exception ex) {
                            BcLogUtil.error(ex);
                        }
                    }
                });
            }
        } else if (ev.type == 12) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        IfxSplashScreenPane.this.setupFinished();
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
    }

    protected void setupStarted() throws Exception {
        HswgLafHelper.getInstance().setupNotException(SwgxDesktopBase.getInstance().getMainFrame());
        Rectangle splashScreenRectangle = null;
        Rectangle winRectangle = new Rectangle();
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle("-fx-background-radius: 10;-fx-background-color: rgba(0,0,0,0.3);");
        this.label = new FxLabel();
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreenRectangle = splashScreen.getBounds();
        } else {
            WritableImage writableImage = new WritableImage(400, 200);
            ImageView imageView = new ImageView((Image)writableImage);
            borderPane.setCenter((Node)imageView);
            Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
            splashScreenRectangle = new Rectangle();
            splashScreenRectangle.x = (int)((screenSize.getWidth() - writableImage.getWidth()) / 2.0);
            splashScreenRectangle.y = (int)((screenSize.getHeight() - writableImage.getHeight()) / 2.0);
            splashScreenRectangle.width = (int)writableImage.getWidth();
            splashScreenRectangle.height = (int)writableImage.getHeight();
        }
        if (this.isOpacity) {
            winRectangle.x = splashScreenRectangle.x + this.pading;
            winRectangle.y = splashScreenRectangle.y + splashScreenRectangle.height - (this.labelHeigt + this.pading * 2);
            winRectangle.width = splashScreenRectangle.width - this.pading * 2;
            winRectangle.height = this.labelHeigt;
        } else {
            winRectangle.x = splashScreenRectangle.x;
            winRectangle.y = splashScreenRectangle.y + splashScreenRectangle.height;
            winRectangle.width = splashScreenRectangle.width;
            winRectangle.height = this.labelHeigt;
        }
        this.label.setPrefHeight(this.labelHeigt);
        this.label.setOpacity(0.6);
        borderPane.setCenter((Node)this.label);
        FxScene scene = new FxScene((Parent)borderPane);
        scene.setFill(null);
        this.stage = new FxStage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(false);
        FxUtil.setWindowLocation((Window)this.stage, winRectangle.x, winRectangle.y, winRectangle.width, winRectangle.height);
        this.stage.show();
        String msg = "Initializing...";
        this.drawText(msg);
    }

    protected void setupFinished() throws Exception {
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreen.close();
        }
        if (this.stage != null) {
            this.stage.close();
        }
    }

    protected void drawText(String text) throws Exception {
        if (!BcStringUtil.isEmpty(text)) {
            this.label.setText(text);
        }
    }
}

