/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;

final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    private static final long serialVersionUID = 7647557958927458271L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private final BigInteger p;
    private final BigInteger g;
    private int l;
    static ObjectIdentifier DH_OID = ObjectIdentifier.of(KnownOIDs.DiffieHellman);

    private static DHComponents decode(byte[] byArray) throws IOException {
        DerValue derValue = null;
        try {
            int n;
            derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("Invalid key format");
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new IOException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (objectIdentifier == null) {
                throw new IOException("Null OID");
            }
            if (derInputStream.available() == 0) {
                throw new IOException("Parameters missing");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.tag == 5) {
                throw new IOException("Null parameters");
            }
            if (derValue3.tag != 48) {
                throw new IOException("Parameters not a SEQUENCE");
            }
            derValue3.data.reset();
            BigInteger bigInteger = derValue3.data.getBigInteger();
            BigInteger bigInteger2 = derValue3.data.getBigInteger();
            int n2 = n = derValue3.data.available() != 0 ? derValue3.data.getInteger() : 0;
            if (derValue3.data.available() != 0) {
                throw new IOException("Extra parameter data");
            }
            byte[] byArray2 = derValue.data.getBitString();
            DerInputStream derInputStream2 = new DerInputStream(byArray2);
            BigInteger bigInteger3 = derInputStream2.getBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Excess key data");
            }
            return new DHComponents(bigInteger3, bigInteger, bigInteger2, n, byArray2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Error parsing key encoding", numberFormatException);
        }
    }

    private static byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, int n, byte[] byArray) {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(DH_OID);
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(bigInteger);
            derOutputStream2.putInteger(bigInteger2);
            if (n != 0) {
                derOutputStream2.putInteger(n);
            }
            DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
            derOutputStream.putDerValue(derValue);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write((byte)48, derOutputStream);
            derOutputStream3.putBitString(byArray);
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.write((byte)48, derOutputStream3);
            return derOutputStream4.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = DHPublicKey.encode(bigInteger2, bigInteger3, n, this.key);
        }
        catch (IOException iOException) {
            throw new ProviderException("Cannot produce ASN.1 encoding", iOException);
        }
    }

    DHPublicKey(byte[] byArray) throws InvalidKeyException {
        DHComponents dHComponents;
        this.encodedKey = (byte[])byArray.clone();
        try {
            dHComponents = DHPublicKey.decode(this.encodedKey);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid encoding", iOException);
        }
        this.y = dHComponents.y;
        this.p = dHComponents.p;
        this.g = dHComponents.g;
        this.l = dHComponents.l;
        this.key = dHComponents.key;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Public Key:" + string + "y:" + string + Debug.toHexString(this.y) + string + "p:" + string + Debug.toHexString(this.p) + string + "g:" + string + Debug.toHexString(this.g));
        if (this.l != 0) {
            stringBuffer.append(string + "l:" + string + "    " + this.l);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return Objects.hash(this.y, this.p, this.g);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPublicKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)object;
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        return this.y.compareTo(dHPublicKey.getY()) == 0 && this.p.compareTo(dHParameterSpec.getP()) == 0 && this.g.compareTo(dHParameterSpec.getG()) == 0;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.encodedKey);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DHComponents dHComponents;
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException("key not deserializable");
        }
        if (this.encodedKey == null || this.encodedKey.length == 0) {
            throw new InvalidObjectException("encoded key not deserializable");
        }
        byte[] byArray = (byte[])this.encodedKey.clone();
        try {
            dHComponents = DHPublicKey.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidObjectException("Invalid encoding" + iOException.getMessage());
        }
        if (!(Arrays.equals(dHComponents.key, this.key) && dHComponents.y.equals(this.y) && dHComponents.p.equals(this.p) && dHComponents.g.equals(this.g) && dHComponents.l == this.l)) {
            throw new InvalidObjectException("encoded key not matching internal fields");
        }
        Arrays.fill(this.key, (byte)0);
        Arrays.fill(this.encodedKey, (byte)0);
        this.key = dHComponents.key;
        this.encodedKey = byArray;
    }

    private static class DHComponents {
        final BigInteger y;
        final BigInteger p;
        final BigInteger g;
        final int l;
        final byte[] key;

        DHComponents(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, byte[] byArray) {
            this.y = bigInteger;
            this.p = bigInteger2;
            this.g = bigInteger3;
            this.l = n;
            this.key = byArray;
        }
    }
}

