/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.event.EventProcessor;

public class BSFEventProcessor
implements EventProcessor {
    BSFEngine engine;
    BSFManager manager;
    String filter;
    String source;
    int lineNo;
    int columnNo;
    Object script;

    BSFEventProcessor(BSFEngine engine, BSFManager manager, String filter, String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.engine = engine;
        this.manager = manager;
        this.filter = filter;
        this.source = source;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
        this.script = script;
    }

    @Override
    public void processEvent(String inFilter, Object[] evtInfo) {
        try {
            this.processExceptionableEvent(inFilter, evtInfo);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println("BSFError: non-exceptionable event delivery threw exception (that's not nice): " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void processExceptionableEvent(String inFilter, Object[] evtInfo) throws Exception {
        if (this.filter != null && !this.filter.equals(inFilter)) {
            return;
        }
        this.engine.exec(this.source, this.lineNo, this.columnNo, this.script);
    }
}

