/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.BasicShape;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Rectangle
extends BasicShape
implements DrawOperation {
    protected int width = 0;
    protected int height = 0;
    protected int arcwidth = 0;
    protected int archeight = 0;

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setArcwidth(int w) {
        this.arcwidth = w;
    }

    public void setArcheight(int h) {
        this.archeight = h;
    }

    @Override
    public PlanarImage executeDrawOperation() {
        this.log("\tCreating Rectangle w=" + this.width + " h=" + this.height + " arcw=" + this.arcwidth + " arch=" + this.archeight);
        BufferedImage bi = new BufferedImage(this.width, this.height, 7);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        if (!this.stroke.equals("transparent")) {
            BasicStroke bStroke = new BasicStroke(this.stroke_width);
            graphics.setColor(ColorMapper.getColorByName(this.stroke));
            graphics.setStroke(bStroke);
            if (this.arcwidth != 0 || this.archeight != 0) {
                graphics.drawRoundRect(0, 0, this.width, this.height, this.arcwidth, this.archeight);
            } else {
                graphics.drawRect(0, 0, this.width, this.height);
            }
        }
        if (!this.fill.equals("transparent")) {
            graphics.setColor(ColorMapper.getColorByName(this.fill));
            if (this.arcwidth != 0 || this.archeight != 0) {
                graphics.fillRoundRect(this.stroke_width, this.stroke_width, this.width - this.stroke_width * 2, this.height - this.stroke_width * 2, this.arcwidth, this.archeight);
            } else {
                graphics.fillRect(this.stroke_width, this.stroke_width, this.width - this.stroke_width * 2, this.height - this.stroke_width * 2);
            }
        }
        int size = this.instructions.size();
        int i = 0;
        while (i < size) {
            ImageOperation instr = (ImageOperation)this.instructions.elementAt(i);
            if (instr instanceof DrawOperation) {
                PlanarImage img = ((DrawOperation)((Object)instr)).executeDrawOperation();
                graphics.drawImage(img.getAsBufferedImage(), null, 0, 0);
            } else if (instr instanceof TransformOperation) {
                graphics = (Graphics2D)bi.getGraphics();
                PlanarImage image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
                bi = image.getAsBufferedImage();
            }
            ++i;
        }
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

