/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class GzCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int compressionLevel;

    public GzCompressAction(File source, File destination, boolean deleteSource, int compressionLevel) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
        this.compressionLevel = compressionLevel;
    }

    @Deprecated
    public GzCompressAction(File source, File destination, boolean deleteSource) {
        this(source, destination, deleteSource, -1);
    }

    @Override
    public boolean execute() throws IOException {
        return GzCompressAction.execute(this.source, this.destination, this.deleteSource, this.compressionLevel);
    }

    @Deprecated
    public static boolean execute(File source, File destination, boolean deleteSource) throws IOException {
        return GzCompressAction.execute(source, destination, deleteSource, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(File source, File destination, boolean deleteSource, int compressionLevel) throws IOException {
        block26: {
            if (!source.exists()) return false;
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileInputStream fis = new FileInputStream(source);
                try {
                    block25: {
                        FileOutputStream fos = new FileOutputStream(destination);
                        try {
                            block24: {
                                ConfigurableLevelGZIPOutputStream gzipOut = new ConfigurableLevelGZIPOutputStream((OutputStream)fos, 8192, compressionLevel);
                                try {
                                    try (BufferedOutputStream os = new BufferedOutputStream(gzipOut, 8192);){
                                        int n;
                                        byte[] inbuf = new byte[8192];
                                        while ((n = fis.read(inbuf)) != -1) {
                                            ((OutputStream)os).write(inbuf, 0, n);
                                        }
                                    }
                                    if (gzipOut == null) break block24;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (gzipOut == null) throw throwable;
                                    ((OutputStream)gzipOut).close();
                                    throw throwable;
                                }
                                ((OutputStream)gzipOut).close();
                            }
                            if (fos == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fos == null) throw throwable;
                            ((OutputStream)fos).close();
                            throw throwable;
                        }
                        ((OutputStream)fos).close();
                    }
                    if (fis == null) break block26;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        if (!deleteSource) return true;
        if (source.delete()) return true;
        LOGGER.warn("Unable to delete {}.", (Object)source);
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return String.valueOf(GzCompressAction.class.getSimpleName()) + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }

    private static final class ConfigurableLevelGZIPOutputStream
    extends GZIPOutputStream {
        ConfigurableLevelGZIPOutputStream(OutputStream out, int bufSize, int level) throws IOException {
            super(out, bufSize);
            this.def.setLevel(level);
        }
    }
}

