/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.script;

import java.util.List;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcResult;

public class SrpUtil {
    private SrpUtil() {
    }

    public static BcResult compileTest(ScriptEngine scriptEngine, String script) throws Exception {
        BcResult result = new BcResult();
        if (scriptEngine instanceof Compilable) {
            Compilable compilable = (Compilable)((Object)scriptEngine);
            try {
                CompiledScript compiledScript = compilable.compile(script);
                BcLogUtil.debug("script compiled.");
                scriptEngine.eval(script);
                result.addInfo("\u30b3\u30f3\u30d1\u30a4\u30eb\u306f\u6210\u529f\u3057\u307e\u3057\u305f");
            }
            catch (Exception ex) {
                result.addError(ex);
            }
        } else {
            result.addError("\u30b3\u30f3\u30d1\u30a4\u30eb\u4e0d\u53ef\u80fd\u306a\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u3067\u3059\u3002" + scriptEngine.toString());
        }
        return result;
    }

    public static BcResult compileTest(String engineName, String script) throws Exception {
        BcResult result = new BcResult();
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("javascript");
        if (scriptEngine == null) {
            result.addError("\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002engineName='" + engineName + "'");
            return result;
        }
        return SrpUtil.compileTest(scriptEngine, script);
    }

    public static void engineList() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = manager.getEngineFactories();
        for (ScriptEngineFactory factory : engineFactories) {
            System.out.println("Engine: " + factory.getEngineName() + ", Version: " + factory.getEngineVersion());
            System.out.println("Language: " + factory.getLanguageName() + ", Version: " + factory.getLanguageVersion());
            System.out.println("Extensions: " + factory.getExtensions());
            System.out.println("MimeTypes: " + factory.getMimeTypes());
            System.out.println("Names: " + factory.getNames());
            System.out.println();
        }
    }

    public static ScriptEngineFactory getEngineFactoryByFileExtension(String fileExtension) throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> scriptEngineFactoryList = manager.getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactoryList) {
            for (String fileExtension2 : scriptEngineFactory.getExtensions()) {
                if (!fileExtension2.equalsIgnoreCase(fileExtension)) continue;
                return scriptEngineFactory;
            }
        }
        return null;
    }
}

