/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.swg;

import java.io.File;
import javax.swing.JOptionPane;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.viewer.FxxDocContentGroup;
import jp.co.extreme.fx.viewer.FxxViwerDesktopPane;
import jp.co.extreme.module.dcmn.swg.DcmnClientModule;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf.stub.ScfHandleStub;
import jp.co.extreme.scf2.client.ScfFileDownloader;
import jp.co.extreme.swing.docviewer.DcfDocumentViewer;
import nlc.lib.doc.DcfBook;

public class IswgDocumentViewer
extends DcfDocumentViewer {
    protected String docHandleId;
    static String msg1 = "\u30d7\u30ec\u30d3\u30e5\u30fc\u5bfe\u8c61\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";

    public boolean setRmiRespons(RmiRespons rmiRes) throws Exception {
        this.setRmiRespons_L2(rmiRes);
        int pageCount = 0;
        if (this.bookReader != null) {
            pageCount = this.bookReader.getPageCount();
        }
        if (pageCount <= 0) {
            JOptionPane.showMessageDialog(this.getOwnerComponent(), BcWords.getInstance().\u4f5c\u6210\u3055\u308c\u305f\u30da\u30fc\u30b8\u306f\u3042\u308a\u307e\u305b\u3093, BcWords.getInstance().information, 1);
            return false;
        }
        boolean printFlag = false;
        switch (this.mode) {
            case 11: {
                this.getFrame().setVisible(true);
                break;
            }
            case 21: 
            case 22: {
                printFlag = this.printOut(-1);
            }
        }
        return printFlag;
    }

    protected void setRmiRespons_L2(RmiRespons rmiRes) throws Exception {
        this.docHandleId = rmiRes.getDataAsString();
        BcLogUtil.debug("tranlL3:docHandleId=" + this.docHandleId);
        String svFilePath = rmiRes.getDataAsString();
        BcLogUtil.debug("tranlL3:svFilePath=" + svFilePath);
        if (BcStringUtil.isEmpty(svFilePath)) {
            return;
        }
        if (ScfClientContainer.getInstance().isClient()) {
            if (this.tempDir == null) {
                this.tempDir = new File(AfbApplication.getInstance().toReal("${APP}data/doc/"));
            }
            if (!this.tempDir.exists()) {
                this.tempDir.mkdirs();
            }
            this.localDocFile = File.createTempFile("doc", ".tmp", this.tempDir);
            ScfFileDownloader fileDownloader = new ScfFileDownloader(ScfClientContainer.getInstance().getAgent());
            BcMonitor mon = new BcMonitor();
            fileDownloader.download(mon, svFilePath, this.localDocFile);
            mon.sync();
        } else {
            this.localDocFile = new File(svFilePath);
        }
        if (this.docHandleId != null) {
            ScfHandleStub.getInstance().removeHandle(this.docHandleId);
        } else {
            this.isStored = true;
        }
        if (this.localDocFile.exists()) {
            this.setLocalFile(this.localDocFile);
        }
    }

    @Override
    protected synchronized void closeTransaction() {
        if (this.localDocFile != null) {
            try {
                if (!this.isStored) {
                    this.localDocFile.delete();
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        this.frame.dispose();
    }

    public static void printPreview_v1(DcfBook dcfBook, String title) throws Exception {
        if (dcfBook == null) {
            JOptionPane.showMessageDialog(null, msg1, BcWords.getInstance().information, 1);
            return;
        }
        IswgDocumentViewer documentViewer = new IswgDocumentViewer();
        DcmnClientModule.getInstance().documentManagerCommonSetup(documentViewer, title);
        documentViewer.setBookReader(dcfBook);
    }

    public static void printPreview_v2(final FxxDocContentGroup docContentGroup) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FxxViwerDesktopPane viwerDesktopPane = new FxxViwerDesktopPane();
                    viwerDesktopPane.setContentGroup(docContentGroup);
                    viwerDesktopPane.show(null);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    public static void printPreview_v2(final DcfBook dcfBook, final String title) throws Exception {
        if (dcfBook == null) {
            JOptionPane.showMessageDialog(null, msg1, BcWords.getInstance().information, 1);
            return;
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FxxDocContentGroup docContentGroup = new FxxDocContentGroup();
                    docContentGroup.setBook(dcfBook);
                    docContentGroup.setTitle(title);
                    IswgDocumentViewer.printPreview_v2(docContentGroup);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }
}

