/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.swg;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.LayerUI;

class RowHeightResizeLayer
extends LayerUI<JScrollPane> {
    private static final int MIN_ROW_HEIGHT = 16;
    private static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    private int mouseYOffset;
    private int resizingRow = -1;
    private Cursor otherCursor = RESIZE_CURSOR;

    RowHeightResizeLayer() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(48L);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c instanceof JLayer) {
            ((JLayer)c).setLayerEventMask(0L);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends JScrollPane> l) {
        Component c = e.getComponent();
        if (c instanceof JTable) {
            JTable table = (JTable)c;
            this.resizingRow = this.getResizeTargetRow(table, e.getPoint());
            if (e.getID() == 501 && this.resizingRow >= 0) {
                this.mouseYOffset = e.getY() - table.getRowHeight(this.resizingRow);
                e.consume();
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JScrollPane> l) {
        Component c = e.getComponent();
        if (!(c instanceof JTable)) {
            return;
        }
        JTable table = (JTable)c;
        if (e.getID() == 503) {
            boolean isResizing = RESIZE_CURSOR.equals(table.getCursor());
            int row = this.getResizeTargetRow(table, e.getPoint());
            if (row >= 0 != isResizing) {
                Cursor tmp = table.getCursor();
                table.setCursor(this.otherCursor);
                this.otherCursor = tmp;
            }
        } else if (e.getID() == 506 && this.resizingRow >= 0) {
            int newHeight = e.getY() - this.mouseYOffset;
            if (newHeight > 16) {
                table.setRowHeight(this.resizingRow, newHeight);
            }
            e.consume();
        }
    }

    private int getResizeTargetRow(JTable table, Point p) {
        int row = table.rowAtPoint(p);
        int col = table.columnAtPoint(p);
        Rectangle r = table.getCellRect(row, col, false);
        r.grow(0, -2);
        if (r.contains(p)) {
            return -1;
        }
        return (double)p.y < r.getCenterY() ? row - 1 : row;
    }
}

