/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mqsv.server;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.module.mqsv.common.MqsvMessageEventHandler;
import jp.co.extreme.module.mqsv.server.MqsvService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MqsvRecieveThread
extends Thread {
    protected BcMonitor threadMon = new BcMonitor();
    protected boolean isStop;
    protected MqsvService messageServer;
    protected Socket socket;

    public MqsvRecieveThread(MqsvService messageServer, Socket socket) {
        this.messageServer = messageServer;
        this.socket = socket;
        this.setPriority(1);
        this.start();
        this.threadMon.lock();
    }

    public void stopThread() {
        this.isStop = true;
    }

    @Override
    public void run() {
        while (!this.isStop) {
            this.threadMon.sync();
            this.run2();
        }
    }

    protected void run2() {
        try {
            byte[] byteArray = BcStreamUtil.read(this.socket.getInputStream());
            if (byteArray == null) {
                return;
            }
            Document reqXmlDoc = this.parseRequestData(byteArray);
            if (this.messageServer.logLevel > 0) {
                BcLogUtil.debug("Message Service:\u30ea\u30af\u30a8\u30b9\u30c8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002");
            }
            this.parseXmlDoc(reqXmlDoc);
            int i = 0;
            while (i < this.messageServer.messagetListenerList.size()) {
                MqsvMessageEventHandler listener = this.messageServer.messagetListenerList.get(i);
                listener.domRecieved(reqXmlDoc);
                ++i;
            }
            Document resXmlDoc = this.createRespons(true);
            BcXmlUtil.output(resXmlDoc, this.socket.getOutputStream(), false);
        }
        catch (Exception ex) {
            BcLogUtil.debug(ex);
            this.messageServer.removeRequestRecieveThread(this);
            this.isStop = true;
        }
    }

    protected Document parseRequestData(byte[] byteArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        InputSource inputSource = new InputSource(byteArrayInputStream);
        inputSource.setEncoding("SJIS");
        Document domDoc = BcXmlUtil.createDocument(inputSource);
        return domDoc;
    }

    protected Document parseXmlDoc(Document reqXmlDoc) throws Exception {
        Element rootElem = reqXmlDoc.getDocumentElement();
        Document resXmlDoc = null;
        if (rootElem.getNodeName().equals("request")) {
            resXmlDoc = this.parseRequestNode(rootElem);
        }
        return resXmlDoc;
    }

    protected Document parseRequestNode(Node domNode) throws Exception {
        Document resXmlDoc = null;
        NodeList domNodeList = domNode.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode2 = domNodeList.item(i);
            domNode2.getNodeName().equals("entryMessageListener");
            ++i;
        }
        return resXmlDoc;
    }

    public Document createRespons(boolean bool) throws Exception {
        Document xmlDoc = BcXmlUtil.createDocument("root", true);
        Element rootElem = xmlDoc.createElement("respons");
        xmlDoc.appendChild(rootElem);
        BcXmlUtil.setTextValue(rootElem, "status", String.valueOf(bool));
        return xmlDoc;
    }
}

