/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.doc.script;

import java.awt.Color;
import java.awt.Font;
import javax.print.attribute.standard.MediaSize;
import jp.co.extreme.awt.AwtColorUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.script.DcfScriptConstants;
import jp.co.extreme.doc.util.DcfConstants;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.shape.DcfArcShape;
import nlc.lib.doc.shape.DcfEllipseShape;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;

public class DcfScriptGenerator {
    protected String lineSeparator = String.valueOf(BcStringUtil.CARRIAGE_RETURN_STR) + BcStringUtil.LINE_FEED_STR;
    protected int groupNo;

    public StringBuilder toScript(DcfPage dcfPage) throws Exception {
        this.groupNo = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("rp {");
        sb.append(this.lineSeparator);
        sb.append("  v=1.00");
        sb.append(';');
        sb.append(this.lineSeparator);
        MediaSize mediaSize = dcfPage.getMediaSize();
        sb.append("  s=" + mediaSize.getMediaSizeName().toString());
        sb.append(';');
        sb.append(this.lineSeparator);
        sb.append("  o=" + DcfScriptConstants.getPageOrientationCode(dcfPage.getPageFormat().getOrientation()));
        sb.append(';');
        sb.append(this.lineSeparator);
        int i = 0;
        while (i < dcfPage.getGroupCount()) {
            DcfShapeGroup shapeGroup = dcfPage.getGroup(i);
            if (shapeGroup.getShapeCount() > 0) {
                sb.append((CharSequence)this.toGroupScript(shapeGroup));
                sb.append(this.lineSeparator);
            }
            ++i;
        }
        sb.append("}");
        sb.append(this.lineSeparator);
        return sb;
    }

    protected StringBuilder toGroupScript(DcfShapeGroup shapeGroup) throws Exception {
        ++this.groupNo;
        StringBuilder sb = new StringBuilder();
        sb.append(this.lineSeparator);
        String shapeGroupName = shapeGroup.getName();
        if (BcStringUtil.isEmpty(shapeGroupName)) {
            shapeGroupName = "grp" + this.groupNo;
        }
        sb.append("  " + shapeGroupName + " {");
        sb.append(this.lineSeparator);
        if (shapeGroup.getRectangle().x != 0.0) {
            sb.append("    x=" + shapeGroup.getRectangle().x);
            sb.append(';');
            sb.append(this.lineSeparator);
        }
        if (shapeGroup.getRectangle().y != 0.0) {
            sb.append("    y=" + shapeGroup.getRectangle().y);
            sb.append(';');
            sb.append(this.lineSeparator);
        }
        if (shapeGroup.getRectangle().width != 0.0) {
            sb.append("    w=" + shapeGroup.getRectangle().width);
            sb.append(';');
            sb.append(this.lineSeparator);
        }
        if (shapeGroup.getRectangle().height != 0.0) {
            sb.append("    h=" + shapeGroup.getRectangle().height);
            sb.append(';');
            sb.append(this.lineSeparator);
        }
        int i = 0;
        while (i < shapeGroup.getShapeCount()) {
            DcfShape shape = shapeGroup.getShape(i);
            sb.append((CharSequence)this.toShapeScript(shape));
            sb.append(this.lineSeparator);
            ++i;
        }
        sb.append("  }");
        return sb;
    }

    protected StringBuilder toShapeScript(DcfShape shape) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (DcfShapeGroup.class.isAssignableFrom(shape.getClass())) {
            BcLogUtil.debug("DcfShapeGroup is nest.");
            DcfShapeGroup shapeGroup = (DcfShapeGroup)shape;
            sb.append((CharSequence)this.toGroupScript(shapeGroup));
            sb.append(this.lineSeparator);
        } else if (DcfTextShape.class.isAssignableFrom(shape.getClass())) {
            DcfTextShape textShape = (DcfTextShape)shape;
            sb.append("    ");
            sb.append((CharSequence)this.toTextScript(textShape));
            sb.append(';');
        } else if (DcfLineShape.class.isAssignableFrom(shape.getClass())) {
            DcfLineShape lineShape = (DcfLineShape)shape;
            sb.append("    ");
            sb.append((CharSequence)this.toLineScript(lineShape));
            sb.append(';');
        } else if (DcfEllipseShape.class.isAssignableFrom(shape.getClass())) {
            DcfEllipseShape ellipseShape = (DcfEllipseShape)shape;
            sb.append("    ");
            sb.append((CharSequence)this.toEllipseScript(ellipseShape));
            sb.append(';');
        } else if (DcfArcShape.class.isAssignableFrom(shape.getClass())) {
            DcfArcShape arcShape = (DcfArcShape)shape;
            sb.append("    ");
            sb.append((CharSequence)this.toArcScript(arcShape));
            sb.append(';');
        } else if (DcfAbstractBarcodeShape.class.isAssignableFrom(shape.getClass())) {
            DcfAbstractBarcodeShape barcodeShape = (DcfAbstractBarcodeShape)shape;
            sb.append("    ");
            sb.append((CharSequence)this.toBarcodeScript(barcodeShape));
            sb.append(';');
        } else {
            throw new Exception("Not supported shape. " + shape.getClass().getName());
        }
        return sb;
    }

    protected void toCommonParameter(DcfShape shape, StringBuilder sb) throws Exception {
        this.itemAppend(sb, shape.getX());
        this.itemAppend(sb, shape.getY());
        sb.insert(0, String.valueOf(BcStringUtil.toStringNotNull(shape.getName())) + ",");
    }

    protected StringBuilder toTextScript(DcfTextShape textShape) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.toCommonParameter(textShape, sb);
        this.itemAppend(sb, textShape.getRectangle().width);
        this.itemAppend(sb, textShape.getRectangle().height);
        if (textShape.lineWidth > 0.0) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lw=" + textShape.lineWidth);
        }
        if (!BcStringUtil.isEmpty(textShape.lineType)) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lt=" + textShape.lineType);
        }
        if (textShape.lineColor != null && !AwtColorUtil.compare(textShape.lineColor, DcfConstants.DEFAULT_LINE_COLOR)) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lc=" + AwtColorUtil.toHex(textShape.lineColor));
        }
        if (textShape.textOrientation != 1) {
            BcStringUtil.appendExceptEmpty(sb, ',', "to=" + DcfScriptConstants.getTextOrientationCode(textShape.textOrientation));
        }
        if (textShape.verticalAlign != 1) {
            BcStringUtil.appendExceptEmpty(sb, ',', "va=" + DcfScriptConstants.getAlignCode(textShape.verticalAlign));
        }
        if (textShape.horizontalAlign != 2) {
            BcStringUtil.appendExceptEmpty(sb, ',', "ha=" + DcfScriptConstants.getAlignCode(textShape.horizontalAlign));
        }
        BcStringUtil.appendExceptEmpty(sb, ',', this.toFontScript(textShape.font, textShape.textColor));
        if (textShape.wrapText) {
            BcStringUtil.appendExceptEmpty(sb, ',', "w");
        }
        if (textShape.textDegrees != 0.0) {
            BcStringUtil.appendExceptEmpty(sb, ',', "td=" + textShape.textDegrees);
        }
        if (textShape.doClip) {
            BcStringUtil.appendExceptEmpty(sb, ',', "\uff43");
        }
        if (!BcStringUtil.isEmpty(textShape.value)) {
            StringBuilder value = BcStringUtil.escapEncode(textShape.value);
            BcStringUtil.appendExceptEmpty(sb, ',', "v=" + BcStringUtil.doubleQuotation(value));
        }
        sb.insert(0, "r(");
        sb.append(")");
        return sb;
    }

    protected StringBuilder toFontScript(Font font, Color textColor) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.appendExceptEmpty(sb, ',', "fn=" + font.getFontName());
        if (font.getSize2D() != 8.0f) {
            BcStringUtil.appendExceptEmpty(sb, ',', "fs=" + font.getSize2D());
        }
        if ((font.getStyle() & 1) != 0) {
            BcStringUtil.appendExceptEmpty(sb, ',', "fb");
        }
        if ((font.getStyle() & 2) != 0) {
            BcStringUtil.appendExceptEmpty(sb, ',', "fi");
        }
        if (textColor != null) {
            BcStringUtil.appendExceptEmpty(sb, ',', "fgc=" + AwtColorUtil.toHex(textColor));
        }
        return sb;
    }

    protected StringBuilder toLineScript(DcfLineShape lineShape) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.toCommonParameter(lineShape, sb);
        this.itemAppend(sb, lineShape.getLine().x2);
        this.itemAppend(sb, lineShape.getLine().y2);
        this.itemAppend(sb, lineShape.lineWidth);
        sb.append(lineShape.lineType);
        sb.append(',');
        sb.insert(0, "l(");
        sb.append(")");
        return sb;
    }

    protected StringBuilder toEllipseScript(DcfEllipseShape ellipseShape) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.toCommonParameter(ellipseShape, sb);
        this.itemAppend(sb, ellipseShape.getRadius());
        sb.insert(0, "e(");
        sb.append(")");
        return sb;
    }

    protected StringBuilder toArcScript(DcfArcShape arcShape) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.toCommonParameter(arcShape, sb);
        this.itemAppend(sb, arcShape.getArc().getWidth());
        this.itemAppend(sb, arcShape.getArc().getHeight());
        this.itemAppend(sb, arcShape.getArc().getStartPoint().getX());
        this.itemAppend(sb, arcShape.getArc().getStartPoint().getY());
        this.itemAppend(sb, arcShape.getArc().getEndPoint().getX());
        this.itemAppend(sb, arcShape.getArc().getEndPoint().getY());
        sb.insert(0, "a(");
        sb.append(")");
        return sb;
    }

    protected StringBuilder toBarcodeScript(DcfAbstractBarcodeShape barcodeShape) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.toCommonParameter(barcodeShape, sb);
        this.itemAppend(sb, barcodeShape.getRectangle().width);
        this.itemAppend(sb, barcodeShape.getRectangle().height);
        BcStringUtil.appendExceptEmpty(sb, ',', "bt=" + barcodeShape.getBarcodeType());
        if (!BcStringUtil.isEmpty(barcodeShape.lineType)) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lt=" + barcodeShape.lineType);
        }
        if (barcodeShape.lineWidth > 0.0) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lw=" + barcodeShape.lineWidth);
        }
        if (barcodeShape.lineColor != null && !AwtColorUtil.compare(barcodeShape.lineColor, DcfConstants.DEFAULT_LINE_COLOR)) {
            BcStringUtil.appendExceptEmpty(sb, ',', "lc=" + AwtColorUtil.toHex(barcodeShape.lineColor));
        }
        if (barcodeShape.font != null) {
            BcStringUtil.appendExceptEmpty(sb, ',', this.toFontScript(barcodeShape.font, barcodeShape.textColor));
        }
        sb.insert(0, "b(");
        sb.append(")");
        sb.append(';');
        return sb;
    }

    protected void itemAppend(StringBuilder sb, double num) {
        BcStringUtil.appendExceptEmpty(sb, ',', this.toString(num));
    }

    protected String toString(double num) {
        String str = Double.toString(num);
        int pointPos = str.indexOf(".");
        if (pointPos >= 0 && str.substring(pointPos + 1, str.length()).equals("0")) {
            str = str.substring(0, pointPos);
        }
        return str;
    }
}

