/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.css.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.css.common.CssConstants;
import jp.co.extreme.html.common.HtmlConstants;

public class CssBuiler
extends BcLoggableObject {
    public static final String delimiter = String.valueOf(BcStringUtil.SEMICOLON_STR) + BcStringUtil.SPACE_STR;
    private List<CharSequence> list = new ArrayList<CharSequence>();

    public CssBuiler clear() {
        this.list.clear();
        return this;
    }

    public static String toElem(String propertyName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(propertyName);
        sb.append(':');
        sb.append(value);
        return sb.toString();
    }

    public static String toElem(CssConstants.CssProperty cssProperty, String value) {
        return CssBuiler.toElem(cssProperty.propertyName, value);
    }

    public CssBuiler addElem(CssConstants.CssProperty propertyName, String ... values) throws Exception {
        String sb = CssBuiler.toElem(propertyName, BcStringUtil.toSsv(values));
        this.list.add(sb);
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder(BcStringUtil.marge(this.list, delimiter));
        sb.append(';');
        this.list.clear();
        return sb.toString();
    }

    public CssBuiler background_color(String param) throws Exception {
        return this.addElem(CssConstants.CssProperty.background_color, param);
    }

    public CssBuiler background_color(HtmlConstants.HtmlColor htmlColor) throws Exception {
        return this.background_color(htmlColor.name());
    }

    public CssBuiler border(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.border, params);
    }

    public CssBuiler border_radius(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.border_radius, params);
    }

    public CssBuiler box_shadow(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.box_shadow, params);
    }

    public CssBuiler color(String param) throws Exception {
        return this.addElem(CssConstants.CssProperty.color, param);
    }

    public CssBuiler color(HtmlConstants.HtmlColor htmlColor) throws Exception {
        return this.color(htmlColor.name());
    }

    public CssBuiler display(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.display, params);
    }

    public CssBuiler font_size(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.font_size, params);
    }

    public CssBuiler gap(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.gap, params);
    }

    public CssBuiler height(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.height, params);
    }

    public CssBuiler margin_left(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.margin_left, params);
    }

    public CssBuiler margin_right(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.margin_right, params);
    }

    public CssBuiler outline(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.outline, params);
    }

    public CssBuiler padding(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.padding, params);
    }

    public CssBuiler text_align(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.text_align, params);
    }

    public CssBuiler text_align(CssConstants.CssAlign align) throws Exception {
        return this.text_align(align.name());
    }

    public CssBuiler vertical_align(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.vertical_align, params);
    }

    public CssBuiler vertical_align(CssConstants.CssAlign align) throws Exception {
        return this.vertical_align(align.name());
    }

    public CssBuiler width(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.width, params);
    }

    public CssBuiler resize(String ... params) throws Exception {
        return this.addElem(CssConstants.CssProperty.resize, params);
    }
}

