/*
 * Decompiled with CFR 0.152.
 */
package nlc.lib.doc;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.print.attribute.standard.MediaSize;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCloneUtil;
import nlc.lib.doc.DcfPageFormat;
import nlc.lib.doc.DcfPaper;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;

public class DcfPage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -301234474844311695L;
    protected DcfPageFormat pageFormat;
    protected MediaSize mediaSize;
    public double xMargin;
    public double yMargin;
    public String title;
    public boolean isBorder;
    protected String overLayName;
    public String printConditionName;
    public Color paperColor;
    protected List<DcfShapeGroup> groupList = new ArrayList<DcfShapeGroup>();
    protected Hashtable<String, DcfShapeGroup> groupHashtable = new Hashtable();

    public DcfPage() throws Exception {
        this.clear();
    }

    public void clear() throws Exception {
        this.pageFormat = new DcfPageFormat();
        this.xMargin = 0.0;
        this.yMargin = 0.0;
        this.title = null;
        this.isBorder = false;
        this.overLayName = null;
        this.printConditionName = null;
        this.paperColor = null;
        this.groupList.clear();
        this.groupHashtable.clear();
    }

    public MediaSize getMediaSize() throws Exception {
        return this.mediaSize;
    }

    public DcfPageFormat getPageFormat() throws Exception {
        return this.pageFormat;
    }

    public void setPageFormat(DcfPageFormat pageFormat) throws Exception {
        this.pageFormat = pageFormat;
    }

    public void addGroup(DcfShapeGroup shapeGroup) throws Exception {
        this.groupList.add(shapeGroup);
        if (!BcStringUtil.isEmpty(shapeGroup.getName())) {
            this.groupHashtable.put(shapeGroup.getName(), shapeGroup);
        }
    }

    public DcfShapeGroup getGroup(int index) throws Exception {
        return this.groupList.get(index);
    }

    public DcfShapeGroup getGroup(String groupName) throws Exception {
        return this.groupHashtable.get(groupName);
    }

    public DcfShape getShape(String name) throws Exception {
        int i = 0;
        while (i < this.getGroupCount()) {
            DcfShapeGroup shapeGroup = this.getGroup(i);
            DcfShape shape = shapeGroup.getShape(name);
            if (shape != null) {
                return shape;
            }
            ++i;
        }
        return null;
    }

    public int getGroupCount() throws Exception {
        return this.groupList.size();
    }

    public int indexOf(DcfShapeGroup shapeGroup) throws Exception {
        return this.groupList.indexOf(shapeGroup);
    }

    public void setPaperSize(MediaSize mediaSize, int orientation) throws Exception {
        this.mediaSize = mediaSize;
        double width = mediaSize.getX(25400) * 72.0f;
        double height = mediaSize.getY(25400) * 72.0f;
        DcfPaper dcfPaper = new DcfPaper();
        switch (orientation) {
            case 0: 
            case 1: 
            case 2: {
                dcfPaper.setSize(width, height);
                dcfPaper.setImageableArea(0.0, 0.0, width, height);
                this.getPageFormat().setOrientation(orientation);
                this.getPageFormat().setPaper(dcfPaper);
                break;
            }
            default: {
                throw new Exception("not suport orientation=" + orientation);
            }
        }
    }

    public String getOverLayName() throws Exception {
        return this.overLayName;
    }

    public void setOverLayName(String overLayName) throws Exception {
        this.overLayName = overLayName;
    }

    public Object clone() throws CloneNotSupportedException {
        return BcCloneUtil.createClone(this);
    }
}

