/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.event.BcEventHandlerList;
import jp.co.extreme.base.event.BcProgressEvent;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcInstanceManager;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcObjectNotFoundException;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxDateField;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxPasswordField;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xsys.model.XsysUser;
import jp.co.extreme.module.xsys.stub.XsysUserStub;

public class XsysUserPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField userNameField = new FxTextField();
    FxPasswordField passwordField = new FxPasswordField();
    FxDateField expirationDateField = new FxDateField();
    FxTextArea permissionIdsTextArea = new FxTextArea();
    XsysUser user;
    Button completionButton;
    Button cancelButton;
    Stage stage;
    BcEventHandlerList eventHandlerList = new BcEventHandlerList();

    public XsysUserPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.userNameField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().userName), new Node[]{this.userNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().passwordExpirationDate), new Node[]{this.expirationDateField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.permissionIdsTextArea.setPrefColumnCount(80);
        this.permissionIdsTextArea.setPrefRowCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().permission), new Node[]{this.permissionIdsTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setUser(XsysUser user) throws Exception {
        this.user = user;
        this.userNameField.setText(user.userName);
        this.passwordField.setText(user.password);
        this.expirationDateField.setYyyyMMdd(user.passwordExpirationDate);
        this.permissionIdsTextArea.setText(user.permissionIds);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            if (this.user == null) {
                this.user = new XsysUser();
            }
            this.user.userName = this.userNameField.getText();
            this.user.password = this.passwordField.getText();
            this.user.passwordExpirationDate = this.expirationDateField.getYyyyMMdd();
            this.user.permissionIds = this.permissionIdsTextArea.getText();
            BcResult result = new BcResult();
            BcInputValidator.getInstance().notNullable(this.user.userName, BcWords.getInstance().userName, result.getErrorList());
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                return;
            }
            this.user = XsysUserStub.getInstance().putUser(this.user);
            this.eventHandlerList.fireEvent(new BcProgressEvent(this.user));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.user.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XsysUserPane.this.userNameField.requestFocus();
                }
                catch (Exception ex) {
                    XsysUserPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XsysUserPane.this.close();
                }
                catch (Exception ex) {
                    XsysUserPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(640.0);
        this.stage.setResizable(true);
        this.stage.setTitle(BcWords.getInstance().user);
        this.stage.showAndWait();
    }

    public static void show2(int profileId, int userId, BcEventHandler eventHandler) throws Exception {
        XsysUserPane userPane = (XsysUserPane)((Object)BcInstanceManager.getInstance().get(XsysUserPane.class, userId));
        if (userPane != null) {
            userPane.stage.toFront();
            return;
        }
        userPane = new XsysUserPane();
        userPane.eventHandlerList.addEventHandler(eventHandler);
        XsysUser user = null;
        if (userId <= 0) {
            user = new XsysUser();
        } else {
            if (user == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(user.getDataId(), (Object)userPane);
        }
        userPane.setUser(user);
        userPane.show(null);
    }
}

