/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.datasource.util;

import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.util.BcRegexUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.sql.SqlUtil;

public final class ScfMmdServerUtil {
    private ScfMmdServerUtil() {
    }

    public static void setMmdField1(ResultSetMetaData rsmd, int columnIndex, MmdField mmdField) throws Exception {
        mmdField.tableName = BcStringUtil.toLowerCase(rsmd.getTableName(columnIndex));
        mmdField.columnName = BcStringUtil.toLowerCase(rsmd.getColumnName(columnIndex));
        String schemaName = rsmd.getSchemaName(columnIndex);
        mmdField.sqlTypeId = rsmd.getColumnType(columnIndex);
        mmdField.dataSize = rsmd.getPrecision(columnIndex);
        mmdField.dataClass = SqlUtil.toJavaType(mmdField.sqlTypeId);
        mmdField.dataClassName = mmdField.dataClass.getName();
        if (Number.class.isAssignableFrom(mmdField.dataClass) && !BcNumberUtil.isFloatingaPointClass(mmdField.dataClass)) {
            MmdUtil.setDecimalDigits(mmdField, rsmd.getScale(columnIndex));
        }
    }

    public static void setMmdField2(MmdField mmdField, int columnIndex, EtcRsmdSupplement rsmdSupplement) throws Exception {
        String columnAliasOrigun = null;
        if (rsmdSupplement != null) {
            mmdField.tableAlias = rsmdSupplement.tableAliasMap.get(mmdField.tableName);
            String key = String.valueOf(mmdField.columnName) + "-" + (columnIndex - 1);
            String tmpStr = rsmdSupplement.columnAliasMap.get(key);
            if (tmpStr != null) {
                columnAliasOrigun = BcStringUtil.isEmpty(mmdField.tableAlias) ? tmpStr.substring(mmdField.tableName.length() + 1) : tmpStr.substring(mmdField.tableAlias.length() + 1);
                mmdField.columnAlias = mmdField.columnName;
            }
        }
        if (columnAliasOrigun != null) {
            mmdField.columnName = columnAliasOrigun;
        }
        mmdField.tableColumnName = MmdUtil.createTableColumnName(mmdField.tableName, mmdField.columnName);
        if (mmdField.fieldDisplay.horizonalAlignment <= 0) {
            mmdField.fieldDisplay.horizonalAlignment = MmdUtil.getHorizonalAlignment(mmdField.dataClass);
        }
        switch (mmdField.sqlTypeId) {
            case 91: {
                mmdField.fieldDisplay.formatPattern = "yyyy/MM/dd";
                mmdField.columnCount = mmdField.fieldDisplay.formatPattern.length();
                break;
            }
            case 92: {
                mmdField.fieldDisplay.formatPattern = "HH:mm:ss";
                mmdField.columnCount = mmdField.fieldDisplay.formatPattern.length();
                break;
            }
            case 93: {
                mmdField.fieldDisplay.formatPattern = "yyyy/MM/dd HH:mm:ss.SSS";
                mmdField.columnCount = mmdField.fieldDisplay.formatPattern.length();
            }
        }
    }

    public static void setMmdDisplayName(MmdField mmdField, DtsWordManager wordManager, Locale locale) throws Exception {
        for (String code : mmdField.codeList) {
            mmdField.fieldDisplay.displayName = ScfMmdServerUtil.getWord(wordManager, code, locale);
            if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.displayName)) break;
        }
    }

    public static String getWord(DtsWordManager wordManager, String wordCode, Locale locale) throws Exception {
        if (BcStringUtil.isEmpty(wordCode)) {
            return null;
        }
        String wordValue = wordManager.getWord(wordCode = wordCode.toLowerCase(), locale.getLanguage());
        if (!BcStringUtil.isEmpty(wordValue)) {
            return wordValue;
        }
        ArrayList<String> wordList = new ArrayList<String>();
        String[] elemnts = BcStringUtil.split(wordCode, BcRegexUtil.escapEncode(BcStringUtil.DOT_STR));
        int i = 0;
        while (i < elemnts.length) {
            String elemnt = elemnts[i];
            if (i > 0) {
                wordList.add(BcStringUtil.DOT_STR);
            }
            if (BcStringUtil.isEmpty(wordValue = wordManager.getWord(elemnt, locale.getLanguage()))) {
                wordList.add(elemnt);
            } else {
                wordList.add(wordValue);
            }
            ++i;
        }
        return BcStringUtil.marge(wordList).toString();
    }

    public static List<MmdField> createMmdFieldList(ResultSetMetaData rsmd, Map<String, Map<String, MmdField>> mmdFieldMap, DtsWordManager wordManager, EtcRsmdSupplement rsmdSupplement, Locale locale, List<String> columnNameList) throws Exception {
        ArrayList<MmdField> mmdFieldList = new ArrayList<MmdField>();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int columnIndex = i + 1;
            MmdField mmdFieldWk = new MmdField();
            ScfMmdServerUtil.setMmdField1(rsmd, columnIndex, mmdFieldWk);
            ScfMmdServerUtil.setMmdField2(mmdFieldWk, columnIndex, rsmdSupplement);
            mmdFieldWk.codeList = MmdUtil.createMmdFiledCodeList(mmdFieldWk);
            MmdField mmdField2 = null;
            if (mmdFieldMap != null) {
                for (String code : mmdFieldWk.codeList) {
                    Map<String, MmdField> mmdFieldMap2 = mmdFieldMap.get(code);
                    if (mmdFieldMap2 != null) {
                        mmdField2 = mmdFieldMap2.get(locale.getLanguage());
                    }
                    if (mmdField2 != null) break;
                }
            }
            if (mmdField2 != null) {
                mmdFieldWk.decimalDigit = mmdField2.decimalDigit;
                if (mmdField2.columnCount > -1) {
                    mmdFieldWk.columnCount = mmdField2.columnCount;
                }
                mmdFieldWk.valueConverterClassName = mmdField2.valueConverterClassName;
                mmdFieldWk.valueConverter = mmdField2.valueConverter;
                mmdFieldWk.fieldDisplay.displayClassName = mmdField2.fieldDisplay.displayClassName;
                mmdFieldWk.fieldDisplay.displayClass = mmdField2.fieldDisplay.displayClass;
                mmdFieldWk.fieldDisplay.shift = mmdField2.fieldDisplay.shift;
                mmdFieldWk.fieldDisplay.formatPattern = mmdField2.fieldDisplay.formatPattern;
                mmdFieldWk.valueMap = mmdField2.valueMap;
                mmdFieldWk.fieldDisplay.horizonalAlignment = mmdField2.fieldDisplay.horizonalAlignment;
                mmdFieldWk.fieldDisplay.renderingConverterClassName = mmdField2.fieldDisplay.renderingConverterClassName;
            }
            if (wordManager != null) {
                ScfMmdServerUtil.setMmdDisplayName(mmdFieldWk, wordManager, locale);
            }
            mmdFieldList.add(mmdFieldWk);
            ++i;
        }
        return mmdFieldList;
    }

    public static List<BcTableColumn> createTableColumnList(ResultSetMetaData rsmd, Map<String, Map<String, MmdField>> mmdFieldMap, DtsWordManager wordManager, EtcRsmdSupplement rsmdSupplement, Locale locale, List<String> columnNameList) throws Exception {
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rsmd, mmdFieldMap, wordManager, rsmdSupplement, locale, columnNameList);
        ArrayList<BcTableColumn> tableColumnList = new ArrayList<BcTableColumn>();
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            BcTableColumn tableColumn = new BcTableColumn();
            tableColumn.setMmdField(mmdField);
            tableColumnList.add(tableColumn);
            ++i;
        }
        return tableColumnList;
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, EtcRsmdSupplement rsmdSupplement, Locale locale, List<String> columnNameList) throws Exception {
        return ScfMmdServerUtil.createTableColumnList(rsmd, dtsSession.getSessionFactory().mmdFieldMap, dtsSession.getSessionFactory().wordManager, rsmdSupplement, locale, columnNameList);
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, EtcRsmdSupplement rsmdSupplement, List<String> columnNameList) throws Exception {
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, rsmdSupplement, dtsSession.getLocale(), columnNameList);
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, Locale locale, List<String> columnNameList) throws Exception {
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, null, locale, columnNameList);
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, List<String> columnNameList) throws Exception {
        EtcRsmdSupplement rsmdSupplement = null;
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, rsmdSupplement, columnNameList);
    }

    public static List<BcTableColumn> createTableColumnList(DtsSession dtsSession, ResultSetMetaData rsmd, EtcRsmdSupplement rsmdSupplement) throws Exception {
        List<String> columnNameList = ScfMmdServerUtil.createTableColumnNameList(rsmd);
        return ScfMmdServerUtil.createTableColumnList(dtsSession, rsmd, rsmdSupplement, dtsSession.getLocale(), columnNameList);
    }

    public static List<BcTableColumn> createTableColumnList(ResultSetMetaData rsmd) throws Exception {
        List<String> columnNameList = ScfMmdServerUtil.createTableColumnNameList(rsmd);
        return ScfMmdServerUtil.createTableColumnList(rsmd, null, null, null, null, columnNameList);
    }

    public static List<String> createTableColumnNameList(ResultSetMetaData rsmd) throws Exception {
        ArrayList<String> tableColumnNameList = new ArrayList<String>();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            int idx = i + 1;
            String tableColumnName = MmdUtil.createTableColumnName(rsmd.getTableName(idx), rsmd.getColumnName(idx));
            BcLogUtil.debug("tableColumnName=" + tableColumnName);
            tableColumnNameList.add(tableColumnName);
            ++i;
        }
        return tableColumnNameList;
    }

    public static MmdField addMmd(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int decimalDigits, int columnCount, String displayValue, int shift, Map cellValueMap, int horizonalAlignment, Map<String, Map<String, MmdField>> mmdFieldMap, DtsWordManager wordManager, Locale locale) throws Exception {
        MmdField mmdField = MmdUtil.createMmdField(tableColumnName, displayJavaClassType, formatPatternWork, decimalDigits, columnCount, cellValueMap, horizonalAlignment, shift);
        String tableColumnName2 = BcStringUtil.toLowerCase(tableColumnName);
        Map<String, MmdField> mmdFieldMap2 = mmdFieldMap.get(tableColumnName2);
        if (mmdFieldMap2 == null) {
            mmdFieldMap2 = new HashMap<String, MmdField>();
            mmdFieldMap.put(tableColumnName2, mmdFieldMap2);
        }
        mmdFieldMap2.put(locale.getLanguage(), mmdField);
        wordManager.putWord(tableColumnName2, locale.getLanguage(), displayValue);
        return mmdField;
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int shift, int decimalDigits, int columnCount, String displayValue, Map cellValueMap, int horizonalAlignment) throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
        Map<String, Map<String, MmdField>> mmdFieldMap = dtsSessionFactory.mmdFieldMap;
        DtsWordManager wordManager = dtsSessionFactory.wordManager;
        MmdField mmdField = ScfMmdServerUtil.addMmd(tableColumnName, displayJavaClassType, formatPatternWork, decimalDigits, columnCount, displayValue, shift, cellValueMap, horizonalAlignment, mmdFieldMap, wordManager, Locale.getDefault());
        return mmdField;
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int decimalDigits, int columnCount, String displayValue, int shift, Map cellValueMap) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, shift, decimalDigits, columnCount, displayValue, cellValueMap, MmdUtil.Alignment.NULL.id);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, 0, -1, columnCount, displayValue, null, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, String formatPatternWork, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, formatPatternWork, -1, columnCount, displayValue, 0, null);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, String formatPatternWork, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, null, formatPatternWork, columnCount, displayValue, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, int decimalDigits, int columnCount, String displayValue, int shift) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, null, decimalDigits, columnCount, displayValue, shift, null);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, Class displayJavaClassType, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        int decimalDigits = -1;
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, displayJavaClassType, null, 0, decimalDigits, columnCount, displayValue, null, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue, int horizonalAlignment) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, "", columnCount, displayValue, horizonalAlignment);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, columnCount, displayValue, -1);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int decimalDigits, int columnCount, String displayValue, int shift) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, Number.class, decimalDigits, columnCount, displayValue, shift);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, int decimalDigits, int columnCount, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, decimalDigits, columnCount, displayValue, 0);
    }

    public static MmdField addColumnNameAndModel(String tableColumnName, String displayValue) throws Exception {
        return ScfMmdServerUtil.addColumnNameAndModel(tableColumnName, -1, displayValue);
    }
}

