/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.text.StringEscapeUtils;

public final class BcCsvUtil {
    private BcCsvUtil() {
    }

    public static CSVFormat createCsvFormat(boolean isTsv) throws Exception {
        CSVFormat.Builder formatBuilder = CSVFormat.RFC4180.builder();
        formatBuilder.setSkipHeaderRecord(false);
        formatBuilder.setQuoteMode(QuoteMode.NON_NUMERIC);
        if (isTsv) {
            formatBuilder.setDelimiter(BcUnicode.HT.char_);
        }
        CSVFormat csvFormat = formatBuilder.build();
        return csvFormat;
    }

    public static CSVFormat createCsvFormat() throws Exception {
        return BcCsvUtil.createCsvFormat(false);
    }

    public static List<String> parseCsvRow(String csvRow, boolean emptyEnable) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(csvRow)) {
            if (emptyEnable) {
                return valueList;
            }
            throw new Exception("csvRow=" + csvRow);
        }
        CharArrayReader charArrayReader = new CharArrayReader(csvRow.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        CSVFormat csvFormat = BcCsvUtil.createCsvFormat();
        CSVParser csvRecords = csvFormat.parse((Reader)bufferedReader);
        Iterator iterator = csvRecords.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                valueList.add(value);
                ++i;
            }
        }
        return valueList;
    }

    public static String toCsv(Collection collection, boolean doEescape, String delimiter) {
        ArrayList<String> newList = new ArrayList<String>();
        for (Object object : collection) {
            String str = BcStringUtil.toString(object);
            if (doEescape && str != null) {
                str = StringEscapeUtils.escapeCsv((String)str);
            }
            newList.add(str);
        }
        return BcStringUtil.marge(newList, delimiter).toString();
    }

    public static String toCsv(Collection collection, boolean doEescape) {
        return BcCsvUtil.toCsv(collection, doEescape, BcStringUtil.COMMA_STR);
    }

    public static String toCsv(Collection collection) {
        return BcCsvUtil.toCsv(collection, true);
    }

    public static String toCsv(String ... strings) {
        return BcCsvUtil.toCsv(Arrays.asList(strings), true);
    }

    public static int getElementIndex(String csvRow, Object element) throws Exception {
        List<String> elementList = BcCsvUtil.parseCsvRow(csvRow, true);
        int i = 0;
        while (i < elementList.size()) {
            String element2 = elementList.get(i);
            if (element.toString().equals(element2)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean hasElement(String csvRow, Object element) throws Exception {
        return BcCsvUtil.getElementIndex(csvRow, element) >= 0;
    }
}

