/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.unix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.time.Duration;
import org.apache.commons.net.echo.EchoTCPClient;
import org.apache.commons.net.echo.EchoUDPClient;

public final class echo {
    public static void echoTCP(String host) throws IOException {
        EchoTCPClient client = new EchoTCPClient();
        client.setDefaultTimeout(60000);
        client.connect(host);
        try {
            System.out.println("Connected to " + host + ".");
            Charset charset = Charset.defaultCharset();
            BufferedReader input = new BufferedReader(new InputStreamReader(System.in, charset));
            Throwable throwable = null;
            Object var6_6 = null;
            try {
                PrintWriter echoOutput = new PrintWriter((Writer)new OutputStreamWriter(client.getOutputStream(), charset), true);
                try {
                    try (BufferedReader echoInput = new BufferedReader(new InputStreamReader(client.getInputStream(), charset));){
                        String line;
                        while ((line = input.readLine()) != null) {
                            echoOutput.println(line);
                            System.out.println(echoInput.readLine());
                        }
                    }
                    if (echoOutput != null) {
                        echoOutput.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (echoOutput != null) {
                        echoOutput.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            client.disconnect();
        }
    }

    public static void echoUDP(String host) throws IOException {
        Charset charset = Charset.defaultCharset();
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in, charset));
        InetAddress address = InetAddress.getByName(host);
        Throwable throwable = null;
        Object var9_6 = null;
        try (EchoUDPClient client = new EchoUDPClient();){
            String line;
            client.open();
            client.setSoTimeout(Duration.ofSeconds(5L));
            System.out.println("Ready to echo to " + host + ".");
            while ((line = input.readLine()) != null) {
                int length;
                byte[] data = line.getBytes(charset);
                client.send(data, address);
                int count = 0;
                do {
                    try {
                        length = client.receive(data);
                    }
                    catch (SocketException e) {
                        System.err.println("SocketException: Timed out and dropped packet");
                        break;
                    }
                    catch (InterruptedIOException e) {
                        System.err.println("InterruptedIOException: Timed out and dropped packet");
                        break;
                    }
                    System.out.print(new String(data, 0, length, charset));
                } while ((count += length) < data.length);
                System.out.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                echo.echoTCP(args[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-udp")) {
            try {
                echo.echoUDP(args[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            System.err.println("Usage: echo [-udp] <hostname>");
            System.exit(1);
        }
    }
}

