/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.event.generator;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdapterClassLoader
extends ClassLoader {
    private static Hashtable classCache = new Hashtable();
    private Class c;
    private Log logger = LogFactory.getLog(this.getClass().getName());

    public synchronized Class defineClass(String name, byte[] b) {
        this.c = this.getLoadedClass(name);
        if (this.c == null) {
            this.c = this.defineClass(name.replace('/', '.'), b, 0, b.length);
            this.put(name, this.c);
        } else {
            this.logger.error("AdapterClassLoader: " + this.c + " previously loaded. Can not redefine class.");
        }
        return this.c;
    }

    protected final Class findClass(String name) {
        return this.get(name);
    }

    protected final Class get(String name) {
        return (Class)classCache.get(name);
    }

    public synchronized Class getLoadedClass(String name) {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        return c;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.getLoadedClass(name);
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected final void put(String name, Class c) {
        classCache.put(name, c);
    }
}

