/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.cf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.bsf.util.IndentWriter;
import org.apache.bsf.util.StringUtils;

public class CodeFormatter {
    public static final int DEFAULT_MAX = 74;
    public static final int DEFAULT_STEP = 2;
    public static final String DEFAULT_DELIM = "(+";
    public static final String DEFAULT_S_DELIM = ",";
    private int maxLineLength = 74;
    private int indentationStep = 2;
    private String delimiters = "(+";
    private String stickyDelimiters = ",";
    private int indent;
    private int hangingIndent;
    private int origIndent;
    private boolean inCPP_Comment;

    private void addTok(StringBuffer targetBuf, StringBuffer tokBuf, IndentWriter out) {
        int tokLength = tokBuf.length();
        int targetLength = targetBuf.length();
        if (this.indent + targetLength + tokLength > this.maxLineLength) {
            if (targetLength == 0) {
                out.println(this.indent, tokBuf.toString());
                this.indent = this.hangingIndent;
                targetBuf.setLength(0);
                return;
            }
            out.println(this.indent, targetBuf.toString().trim());
            this.indent = this.hangingIndent;
            targetBuf.setLength(0);
        }
        targetBuf.append(tokBuf.toString());
    }

    public void formatCode(Reader source, Writer target) {
        BufferedReader in = new BufferedReader(source);
        IndentWriter out = new IndentWriter(new BufferedWriter(target), true);
        try {
            String line;
            this.origIndent = 0;
            this.inCPP_Comment = false;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    this.indent = this.origIndent;
                    this.hangingIndent = this.indent + this.indentationStep;
                    this.printLine(line, out);
                    continue;
                }
                out.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public int getIndentationStep() {
        return this.indentationStep;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public String getStickyDelimiters() {
        return this.stickyDelimiters;
    }

    private void printLine(String line, IndentWriter out) {
        String lastLine;
        char[] source = line.toCharArray();
        char quoteChar = ' ';
        boolean inEscapeSequence = false;
        boolean inString = false;
        StringBuffer tokBuf = new StringBuffer();
        StringBuffer targetBuf = new StringBuffer(this.hangingIndent + line.length());
        int i = 0;
        while (i < source.length) {
            block24: {
                char ch;
                block25: {
                    block23: {
                        ch = source[i];
                        if (!inEscapeSequence) break block23;
                        tokBuf.append(ch);
                        inEscapeSequence = false;
                        break block24;
                    }
                    if (!inString) break block25;
                    switch (ch) {
                        case '\\': {
                            tokBuf.append('\\');
                            inEscapeSequence = true;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            tokBuf.append(ch);
                            if (ch == quoteChar) {
                                this.addTok(targetBuf, tokBuf, out);
                                tokBuf.setLength(0);
                                inString = false;
                                break;
                            }
                            break block24;
                        }
                        case '\t': {
                            tokBuf.append(ch);
                            break;
                        }
                        default: {
                            if (ch > '\u001f') {
                                tokBuf.append(ch);
                                break;
                            }
                            break block24;
                        }
                    }
                    break block24;
                }
                if (this.inCPP_Comment) {
                    tokBuf.append(ch);
                    if (ch == '/' && i > 0 && source[i - 1] == '*') {
                        this.inCPP_Comment = false;
                    }
                } else {
                    switch (ch) {
                        case '/': {
                            tokBuf.append(ch);
                            if (i <= 0 || source[i - 1] != '/') break;
                            String tokStr = tokBuf.append(source, i + 1, source.length - (i + 1)).toString();
                            out.println(this.indent, targetBuf.append(tokStr).toString());
                            return;
                        }
                        case '*': {
                            tokBuf.append(ch);
                            if (i <= 0 || source[i - 1] != '/') break;
                            this.inCPP_Comment = true;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            this.addTok(targetBuf, tokBuf, out);
                            tokBuf.setLength(0);
                            tokBuf.append(ch);
                            quoteChar = ch;
                            inString = true;
                            break;
                        }
                        case '\t': {
                            tokBuf.append(StringUtils.getChars(this.indentationStep, ' '));
                            break;
                        }
                        case '{': {
                            tokBuf.append(ch);
                            this.origIndent += this.indentationStep;
                            break;
                        }
                        case '}': {
                            tokBuf.append(ch);
                            this.origIndent -= this.indentationStep;
                            if (i != 0) break;
                            this.indent = this.origIndent;
                            break;
                        }
                        default: {
                            if (ch <= '\u001f') break;
                            if (this.delimiters.indexOf(ch) != -1) {
                                this.addTok(targetBuf, tokBuf, out);
                                tokBuf.setLength(0);
                                tokBuf.append(ch);
                                break;
                            }
                            if (this.stickyDelimiters.indexOf(ch) != -1) {
                                tokBuf.append(ch);
                                this.addTok(targetBuf, tokBuf, out);
                                tokBuf.setLength(0);
                                break;
                            }
                            tokBuf.append(ch);
                        }
                    }
                }
            }
            ++i;
        }
        if (tokBuf.length() > 0) {
            this.addTok(targetBuf, tokBuf, out);
        }
        if ((lastLine = targetBuf.toString().trim()).length() > 0) {
            out.println(this.indent, lastLine);
        }
    }

    public void setDelimiters(String newDelimiters) {
        this.delimiters = newDelimiters;
    }

    public void setIndentationStep(int newIndentationStep) {
        this.indentationStep = newIndentationStep < 0 ? 0 : newIndentationStep;
    }

    public void setMaxLineLength(int newMaxLineLength) {
        this.maxLineLength = newMaxLineLength < 0 ? 0 : newMaxLineLength;
    }

    public void setStickyDelimiters(String newStickyDelimiters) {
        this.stickyDelimiters = newStickyDelimiters;
    }
}

