/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.classfile.Visitor;

public final class StackMapEntry
implements Node,
Cloneable {
    private int frame_type;
    private int byte_code_offset;
    private StackMapType[] types_of_locals;
    private StackMapType[] types_of_stack_items;
    private ConstantPool constant_pool;

    StackMapEntry(DataInput input, ConstantPool constantPool) throws IOException {
        this(input.readByte() & 0xFF, -1, null, null, constantPool);
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            this.byte_code_offset = this.frame_type - 0;
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            this.byte_code_offset = this.frame_type - 64;
            this.types_of_stack_items = new StackMapType[1];
            this.types_of_stack_items[0] = new StackMapType(input, constantPool);
        } else if (this.frame_type == 247) {
            this.byte_code_offset = input.readShort();
            this.types_of_stack_items = new StackMapType[1];
            this.types_of_stack_items[0] = new StackMapType(input, constantPool);
        } else if (this.frame_type >= 248 && this.frame_type <= 250) {
            this.byte_code_offset = input.readShort();
        } else if (this.frame_type == 251) {
            this.byte_code_offset = input.readShort();
        } else if (this.frame_type >= 252 && this.frame_type <= 254) {
            this.byte_code_offset = input.readShort();
            int number_of_locals = this.frame_type - 251;
            this.types_of_locals = new StackMapType[number_of_locals];
            int i = 0;
            while (i < number_of_locals) {
                this.types_of_locals[i] = new StackMapType(input, constantPool);
                ++i;
            }
        } else if (this.frame_type == 255) {
            this.byte_code_offset = input.readShort();
            int number_of_locals = input.readShort();
            this.types_of_locals = new StackMapType[number_of_locals];
            int i = 0;
            while (i < number_of_locals) {
                this.types_of_locals[i] = new StackMapType(input, constantPool);
                ++i;
            }
            int number_of_stack_items = input.readShort();
            this.types_of_stack_items = new StackMapType[number_of_stack_items];
            int i2 = 0;
            while (i2 < number_of_stack_items) {
                this.types_of_stack_items[i2] = new StackMapType(input, constantPool);
                ++i2;
            }
        } else {
            throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frame_type);
        }
    }

    @Deprecated
    public StackMapEntry(int byteCodeOffset, int numberOfLocals, StackMapType[] typesOfLocals, int numberOfStackItems, StackMapType[] typesOfStackItems, ConstantPool constantPool) {
        this.byte_code_offset = byteCodeOffset;
        this.types_of_locals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.types_of_stack_items = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constant_pool = constantPool;
    }

    public StackMapEntry(int tag, int byteCodeOffset, StackMapType[] typesOfLocals, StackMapType[] typesOfStackItems, ConstantPool constantPool) {
        this.frame_type = tag;
        this.byte_code_offset = byteCodeOffset;
        this.types_of_locals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.types_of_stack_items = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constant_pool = constantPool;
    }

    public void dump(DataOutputStream file) throws IOException {
        file.write(this.frame_type);
        if (this.frame_type < 0 || this.frame_type > 63) {
            if (this.frame_type >= 64 && this.frame_type <= 127) {
                this.types_of_stack_items[0].dump(file);
            } else if (this.frame_type == 247) {
                file.writeShort(this.byte_code_offset);
                this.types_of_stack_items[0].dump(file);
            } else if (this.frame_type >= 248 && this.frame_type <= 250) {
                file.writeShort(this.byte_code_offset);
            } else if (this.frame_type == 251) {
                file.writeShort(this.byte_code_offset);
            } else if (this.frame_type >= 252 && this.frame_type <= 254) {
                file.writeShort(this.byte_code_offset);
                StackMapType[] stackMapTypeArray = this.types_of_locals;
                int n = this.types_of_locals.length;
                int n2 = 0;
                while (n2 < n) {
                    StackMapType type = stackMapTypeArray[n2];
                    type.dump(file);
                    ++n2;
                }
            } else if (this.frame_type == 255) {
                StackMapType type;
                file.writeShort(this.byte_code_offset);
                file.writeShort(this.types_of_locals.length);
                StackMapType[] stackMapTypeArray = this.types_of_locals;
                int n = this.types_of_locals.length;
                int n3 = 0;
                while (n3 < n) {
                    type = stackMapTypeArray[n3];
                    type.dump(file);
                    ++n3;
                }
                file.writeShort(this.types_of_stack_items.length);
                stackMapTypeArray = this.types_of_stack_items;
                n = this.types_of_stack_items.length;
                n3 = 0;
                while (n3 < n) {
                    type = stackMapTypeArray[n3];
                    type.dump(file);
                    ++n3;
                }
            } else {
                throw new ClassFormatException("Invalid Stack map table tag: " + this.frame_type);
            }
        }
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder(64);
        buf.append("(");
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            buf.append("SAME");
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            buf.append("SAME_LOCALS_1_STACK");
        } else if (this.frame_type == 247) {
            buf.append("SAME_LOCALS_1_STACK_EXTENDED");
        } else if (this.frame_type >= 248 && this.frame_type <= 250) {
            buf.append("CHOP ").append(String.valueOf(251 - this.frame_type));
        } else if (this.frame_type == 251) {
            buf.append("SAME_EXTENDED");
        } else if (this.frame_type >= 252 && this.frame_type <= 254) {
            buf.append("APPEND ").append(String.valueOf(this.frame_type - 251));
        } else if (this.frame_type == 255) {
            buf.append("FULL");
        } else {
            buf.append("UNKNOWN (").append(this.frame_type).append(")");
        }
        buf.append(", offset delta=").append(this.byte_code_offset);
        if (this.types_of_locals.length > 0) {
            buf.append(", locals={");
            i = 0;
            while (i < this.types_of_locals.length) {
                buf.append(this.types_of_locals[i]);
                if (i < this.types_of_locals.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append("}");
        }
        if (this.types_of_stack_items.length > 0) {
            buf.append(", stack items={");
            i = 0;
            while (i < this.types_of_stack_items.length) {
                buf.append(this.types_of_stack_items[i]);
                if (i < this.types_of_stack_items.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append("}");
        }
        buf.append(")");
        return buf.toString();
    }

    int getMapEntrySize() {
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            return 1;
        }
        if (this.frame_type >= 64 && this.frame_type <= 127) {
            return 1 + (this.types_of_stack_items[0].hasIndex() ? 3 : 1);
        }
        if (this.frame_type == 247) {
            return 3 + (this.types_of_stack_items[0].hasIndex() ? 3 : 1);
        }
        if (this.frame_type >= 248 && this.frame_type <= 250) {
            return 3;
        }
        if (this.frame_type == 251) {
            return 3;
        }
        if (this.frame_type >= 252 && this.frame_type <= 254) {
            int len = 3;
            StackMapType[] stackMapTypeArray = this.types_of_locals;
            int n = this.types_of_locals.length;
            int n2 = 0;
            while (n2 < n) {
                StackMapType types_of_local = stackMapTypeArray[n2];
                len += types_of_local.hasIndex() ? 3 : 1;
                ++n2;
            }
            return len;
        }
        if (this.frame_type == 255) {
            int len = 7;
            StackMapType[] stackMapTypeArray = this.types_of_locals;
            int n = this.types_of_locals.length;
            int n3 = 0;
            while (n3 < n) {
                StackMapType types_of_local = stackMapTypeArray[n3];
                len += types_of_local.hasIndex() ? 3 : 1;
                ++n3;
            }
            stackMapTypeArray = this.types_of_stack_items;
            n = this.types_of_stack_items.length;
            n3 = 0;
            while (n3 < n) {
                StackMapType types_of_stack_item = stackMapTypeArray[n3];
                len += types_of_stack_item.hasIndex() ? 3 : 1;
                ++n3;
            }
            return len;
        }
        throw new RuntimeException("Invalid StackMap frame_type: " + this.frame_type);
    }

    public void setFrameType(int f) {
        if (f >= 0 && f <= 63) {
            this.byte_code_offset = f - 0;
        } else if (f >= 64 && f <= 127) {
            this.byte_code_offset = f - 64;
        } else if (!(f == 247 || f >= 248 && f <= 250 || f == 251 || f >= 252 && f <= 254 || f == 255)) {
            throw new RuntimeException("Invalid StackMap frame_type");
        }
        this.frame_type = f;
    }

    public int getFrameType() {
        return this.frame_type;
    }

    public void setByteCodeOffset(int new_offset) {
        if (new_offset < 0 || new_offset > Short.MAX_VALUE) {
            throw new RuntimeException("Invalid StackMap offset: " + new_offset);
        }
        if (this.frame_type >= 0 && this.frame_type <= 63) {
            this.frame_type = new_offset > 63 ? 251 : new_offset;
        } else if (this.frame_type >= 64 && this.frame_type <= 127) {
            this.frame_type = new_offset > 63 ? 247 : 64 + new_offset;
        } else if (!(this.frame_type == 247 || this.frame_type >= 248 && this.frame_type <= 250 || this.frame_type == 251 || this.frame_type >= 252 && this.frame_type <= 254 || this.frame_type == 255)) {
            throw new RuntimeException("Invalid StackMap frame_type: " + this.frame_type);
        }
        this.byte_code_offset = new_offset;
    }

    public void updateByteCodeOffset(int delta) {
        this.setByteCodeOffset(this.byte_code_offset + delta);
    }

    public int getByteCodeOffset() {
        return this.byte_code_offset;
    }

    @Deprecated
    public void setNumberOfLocals(int n) {
    }

    public int getNumberOfLocals() {
        return this.types_of_locals.length;
    }

    public void setTypesOfLocals(StackMapType[] types) {
        this.types_of_locals = types != null ? types : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfLocals() {
        return this.types_of_locals;
    }

    @Deprecated
    public void setNumberOfStackItems(int n) {
    }

    public int getNumberOfStackItems() {
        return this.types_of_stack_items.length;
    }

    public void setTypesOfStackItems(StackMapType[] types) {
        this.types_of_stack_items = types != null ? types : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.types_of_stack_items;
    }

    public StackMapEntry copy() {
        StackMapEntry e;
        try {
            e = (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Clone Not Supported");
        }
        e.types_of_locals = new StackMapType[this.types_of_locals.length];
        int i = 0;
        while (i < this.types_of_locals.length) {
            e.types_of_locals[i] = this.types_of_locals[i].copy();
            ++i;
        }
        e.types_of_stack_items = new StackMapType[this.types_of_stack_items.length];
        i = 0;
        while (i < this.types_of_stack_items.length) {
            e.types_of_stack_items[i] = this.types_of_stack_items[i].copy();
            ++i;
        }
        return e;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMapEntry(this);
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }
}

