/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMap
extends Attribute {
    private StackMapEntry[] map;

    public StackMap(int name_index, int length, StackMapEntry[] map, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map;
    }

    StackMap(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.map = new StackMapEntry[map_length];
        int i = 0;
        while (i < map_length) {
            this.map[i] = new StackMapEntry(input, constant_pool);
            ++i;
        }
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        StackMapEntry[] stackMapEntryArray = this.map;
        int n = this.map.length;
        int n2 = 0;
        while (n2 < n) {
            StackMapEntry entry = stackMapEntryArray[n2];
            entry.dump(file);
            ++n2;
        }
    }

    public StackMapEntry[] getStackMap() {
        return this.map;
    }

    public void setStackMap(StackMapEntry[] map) {
        this.map = map;
        int len = 2;
        StackMapEntry[] stackMapEntryArray = map;
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            StackMapEntry element = stackMapEntryArray[n2];
            len += element.getMapEntrySize();
            ++n2;
        }
        this.setLength(len);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        int i = 0;
        while (i < this.map.length) {
            buf.append(this.map[i]);
            if (i < this.map.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map.length];
        int i = 0;
        while (i < this.map.length) {
            c.map[i] = this.map[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMap(this);
    }

    public int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

