/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgOptionWorkPanel;

public class SwgOptionPane
implements Serializable {
    private static final long serialVersionUID = 7665250874354413175L;

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        int resValue = -1;
        try {
            SwgOptionWorkPanel optionWorkPanel = new SwgOptionWorkPanel();
            optionWorkPanel.optionType = optionType;
            optionWorkPanel.message = message;
            optionWorkPanel.title = title;
            optionWorkPanel.icon = icon;
            optionWorkPanel.image = SwgOptionPane.getImage(messageType);
            optionWorkPanel.setup();
            return optionWorkPanel.showAsDialog(parentComponent);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showMessageDialog(parentComponent, ex.getMessage(), BcWords.getInstance().exception, 0);
            return resValue;
        }
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        SwgOptionPane.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        ImageIcon imageIcon = SwgOptionPane.getImageIcon(messageType);
        SwgOptionPane.showMessageDialog(parentComponent, message, title, messageType, imageIcon);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        try {
            SwgOptionWorkPanel optionWorkPanel = new SwgOptionWorkPanel();
            optionWorkPanel.optionType = optionType;
            optionWorkPanel.message = message;
            optionWorkPanel.title = title;
            optionWorkPanel.icon = icon;
            optionWorkPanel.image = SwgOptionPane.getImage(messageType);
            optionWorkPanel.setup();
            return optionWorkPanel.showAsDialog(parentComponent);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showMessageDialog(parentComponent, ex.getMessage(), BcWords.getInstance().exception, 0);
            return -1;
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        return SwgOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, Icon icon) {
        return SwgOptionPane.showConfirmDialog(parentComponent, message, title, optionType, 3, icon);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        ImageIcon imageIcon = SwgOptionPane.getImageIcon(3);
        return SwgOptionPane.showConfirmDialog(parentComponent, message, title, optionType, imageIcon);
    }

    public static Image getImage(int messageType) throws Exception {
        BufferedImage image = null;
        switch (messageType) {
            case 0: {
                image = AwtImageHelper.getImage("error_64x64.png");
                break;
            }
            case 1: {
                image = AwtImageHelper.getImage("information_64x64.png");
                break;
            }
            case 2: {
                image = AwtImageHelper.getImage("sign_warning_64x64.png");
                break;
            }
            case 3: {
                image = AwtImageHelper.getImage("question_64x64.png");
                break;
            }
        }
        return image;
    }

    public static ImageIcon getImageIcon(int messageType) {
        ImageIcon imageIcon = null;
        try {
            Image image = SwgOptionPane.getImage(messageType);
            if (image != null) {
                imageIcon = new ImageIcon(image);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return imageIcon;
    }
}

