/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.scf4.swg.HswgTableDisplayUtil;
import jp.co.extreme.scf4.table.ScfColumnContext;

public class HswgColumnContextTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -376033164632286845L;
    List<ScfColumnContext> columnContextList;

    public HswgColumnContextTableModel(List<ScfColumnContext> columnContextList) throws Exception {
        this.columnContextList = columnContextList;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnId) {
        return Object.class;
    }

    @Override
    public int getRowCount() {
        return this.columnContextList.size();
    }

    @Override
    public Object getValueAt(int rowId, int columnId) {
        ScfColumnContext columnContext = this.columnContextList.get(rowId);
        Object value = null;
        switch (columnId) {
            case 0: {
                value = columnContext.headerValue;
                break;
            }
            case 1: {
                value = columnContext.index;
                break;
            }
            case 2: {
                value = HswgTableDisplayUtil.toVisible(columnContext.visible);
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int rowId, int columnId) {
        ScfColumnContext columnContext = this.columnContextList.get(rowId);
        switch (columnId) {
            case 1: {
                columnContext.index = BcNumberUtil.parseInteger(value, -1);
                break;
            }
            case 2: {
                columnContext.visible = HswgTableDisplayUtil.toVisibleInt((Boolean)value);
            }
        }
    }
}

