/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.server;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.scf4.dao.ScfLockDAO;
import jp.co.extreme.sql.SqlConnection;

public class ZscfLockManager {
    protected Map<CharSequence, DtsSession> lockMap = new HashMap<CharSequence, DtsSession>();

    private ZscfLockManager() {
    }

    public static ZscfLockManager getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(DtsSession dtsSession, String lockName, String groupName, Object owner, Object note) throws Exception {
        Map<CharSequence, DtsSession> map = this.lockMap;
        synchronized (map) {
            boolean success = false;
            int selectCnt1 = 0;
            SqlConnection sqlConn = dtsSession.getConnection();
            try {
                selectCnt1 = ScfLockDAO.getInstance().selectForUpdate(sqlConn, lockName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (selectCnt1 > 0) {
                int updateCnt = 0;
                if (updateCnt > 0) {
                    dtsSession.commit();
                    success = true;
                }
            } else {
                int insertCnt = 0;
                if (insertCnt > 0) {
                    dtsSession.commit();
                    success = true;
                }
            }
            if (success) {
                int selectCnt2 = 0;
                try {
                    selectCnt2 = ScfLockDAO.getInstance().selectForUpdate(sqlConn, lockName);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (selectCnt2 <= 0) {
                    success = false;
                }
            }
            this.lockMap.put(lockName, dtsSession);
            BcLogUtil.debug("lock:" + lockName + " success=" + success);
            return success;
        }
    }

    public boolean unlock(String lockName) throws Exception {
        return true;
    }

    public Object unlockForce() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("lockMap.size()=" + this.lockMap.size());
        for (Map.Entry<CharSequence, DtsSession> mapEntry : this.lockMap.entrySet()) {
            String lockName = (String)mapEntry.getKey();
            BcLogUtil.debug("lockName=" + lockName);
            DtsSession dtsSession = mapEntry.getValue();
            if (dtsSession == null) continue;
            try {
                dtsSession.commit();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            try {
                dtsSession.desturuct();
                sb.append("\n" + lockName + "\uff1aunlocked");
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        return sb;
    }

    public Object getLockInfo() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("lockMap.size()=" + this.lockMap.size());
        for (Map.Entry<CharSequence, DtsSession> mapEntry : this.lockMap.entrySet()) {
            String lockName = (String)mapEntry.getKey();
            sb.append("\n" + lockName + "\uff1aunlocked");
            DtsSession dtsSession = mapEntry.getValue();
            if (dtsSession != null) continue;
        }
        return sb;
    }

    /* synthetic */ ZscfLockManager(ZscfLockManager zscfLockManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final ZscfLockManager instance = new ZscfLockManager(null);

        private SingletonHolder() {
        }
    }
}

