/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.co.extreme.base.core.BcInteger;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf4.model.ScfCalendar;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class ScfCalendarDAO
extends OrmAbstractDAO {
    private ScfCalendarDAO() {
        super(new Object[0]);
        this.setTableName("frwk_calendar");
    }

    public static ScfCalendarDAO getInstance() {
        return SingletonHolder.instance;
    }

    protected List<String> getUpdateColumnList() throws Exception {
        if (this.updateColumnList != null) {
            return this.updateColumnList;
        }
        this.updateColumnList = new ArrayList();
        this.updateColumnList.add("date_");
        this.updateColumnList.add("day_of_week");
        this.updateColumnList.add("day_of_week_in_month");
        this.updateColumnList.add("day_class_id");
        this.updateColumnList.add("name");
        return this.updateColumnList;
    }

    public List<Object> toValueList(ScfCalendar fwCalendar) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.add(fwCalendar.date);
        valueList.add(fwCalendar.dayOfWeek);
        valueList.add(fwCalendar.dayOfWeekInMonth);
        valueList.add(fwCalendar.dayClassId);
        valueList.add(fwCalendar.name);
        return valueList;
    }

    public String getSelectColumns01(String tableAlias) throws Exception {
        String asTable2 = null;
        asTable2 = BcStringUtil.isEmpty(tableAlias) ? " ," : " ," + tableAlias + ".";
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getPersistenceProxy().createCommonSelectPhrase(ScfCalendar.class, tableAlias));
        int i = 0;
        while (i < this.getUpdateColumnList().size()) {
            sb.append(String.valueOf(asTable2) + this.getUpdateColumnList().get(i));
            ++i;
        }
        return sb.toString();
    }

    public int putCalendar(DtsSession dtsSession, ScfCalendar fwCalendar) throws Exception {
        List<String> columnList = this.getUpdateColumnList();
        List<Object> valueList = this.toValueList(fwCalendar);
        int dataId = this.getPersistenceProxy().putEntity(dtsSession, this.tableName, columnList, valueList, fwCalendar);
        return dataId;
    }

    public int deleteCalendar(DtsSession dtsSession, int date) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder(256);
        query.append(" DELETE FROM " + this.tableName + " WHERE" + " date_=" + date);
        int deletedCount = 0;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            deletedCount = stmt.executeUpdate(query.toString());
        }
        return deletedCount;
    }

    protected void getCalendar(DtsSession dtsSession, SqlResultSet rs, BcInteger columnIndex, ScfCalendar fwCalendar) throws Exception {
        this.getPersistenceProxy().transResultset(dtsSession, rs, columnIndex, fwCalendar);
        fwCalendar.date = rs.getInt(columnIndex);
        fwCalendar.dayOfWeek = rs.getShort(columnIndex);
        fwCalendar.dayOfWeekInMonth = rs.getShort(columnIndex);
        fwCalendar.dayClassId = rs.getShort(columnIndex);
        fwCalendar.name = rs.getString(columnIndex);
    }

    protected ScfCalendar getCalendar(DtsSession dtsSession, String query) throws Exception {
        ScfCalendar fwCalendar = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                BcInteger columnIndex = new BcInteger();
                fwCalendar = new ScfCalendar();
                this.getCalendar(dtsSession, rs, columnIndex, fwCalendar);
            }
            rs.close();
        }
        return fwCalendar;
    }

    public ScfCalendar getCalendar(DtsSession dtsSession, int date) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        Object fwCalendar = null;
        String query = " SELECT " + this.getSelectColumns01(null) + " FROM " + this.tableName + " WHERE date_=" + date;
        return this.getCalendar(dtsSession, query);
    }

    public void createCalendar(DtsSession dtsSession, int date1, int date2) throws Exception {
        Calendar tmpCal = BcTimeUtil.toCalendar(date1);
        tmpCal.add(5, -1);
        boolean tmpCnt = false;
        int curDate = 0;
        while (true) {
            tmpCal.add(5, 1);
            curDate = BcTimeUtil.toYyyyMMdd(tmpCal);
            if (curDate > date2) break;
            ScfCalendar fwCalendar = new ScfCalendar();
            fwCalendar.date = BcTimeUtil.toYyyyMMdd(tmpCal);
            fwCalendar.dayOfWeek = tmpCal.get(7);
            fwCalendar.dayOfWeekInMonth = tmpCal.get(8);
            switch (fwCalendar.date) {
                case 20090101: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u5143\u65e5";
                    break;
                }
                case 20090112: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u6210\u4eba\u306e\u65e5";
                    break;
                }
                case 20090211: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
                    break;
                }
                case 20090320: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u6625\u5206\u306e\u65e5";
                    break;
                }
                case 20090429: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u662d\u548c\u306e\u65e5";
                    break;
                }
                case 20090503: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u61b2\u6cd5\u8a18\u5ff5\u65e5";
                    break;
                }
                case 20090504: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u307f\u3069\u308a\u306e\u65e5";
                    break;
                }
                case 20090505: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u3053\u3069\u3082\u306e\u65e5";
                    break;
                }
                case 20090506: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u632f\u66ff\u4f11\u65e5";
                    break;
                }
                case 20090720: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u6d77\u306e\u65e5";
                    break;
                }
                case 20090921: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u656c\u8001\u306e\u65e5";
                    break;
                }
                case 20090922: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u56fd\u6c11\u306e\u4f11\u65e5";
                    break;
                }
                case 20090923: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u79cb\u5206\u306e\u65e5";
                    break;
                }
                case 20091012: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u4f53\u80b2\u306e\u65e5";
                    break;
                }
                case 20091103: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u6587\u5316\u306e\u65e5";
                    break;
                }
                case 20091123: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
                    break;
                }
                case 20091223: {
                    fwCalendar.dayClassId = 2;
                    fwCalendar.name = "\u5929\u7687\u8a95\u751f\u65e5";
                    break;
                }
                default: {
                    fwCalendar.dayClassId = 1;
                }
            }
            this.putCalendar(dtsSession, fwCalendar);
        }
    }

    /* synthetic */ ScfCalendarDAO(ScfCalendarDAO scfCalendarDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfCalendarDAO instance = new ScfCalendarDAO(null);

        private SingletonHolder() {
        }
    }
}

