/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcEventHandlerManager;
import jp.co.extreme.http.client.HtclContentLoader;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.fx.XsodBillFixPane;
import jp.co.extreme.module.xsod.fx.XsodDesktop;
import jp.co.extreme.module.xsod.fx.XsodEventHandler;
import jp.co.extreme.module.xsod.fx.XsodOrderPlanFixPane;
import jp.co.extreme.module.xsod.fx.XsodSignageController;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.module.xsod.model.XsodCondition;
import jp.co.extreme.module.xsod.model.XsodMenuData;
import jp.co.extreme.module.xsod.model.XsodMerchandisePack;
import jp.co.extreme.module.xsod.model.XsodOrder;
import jp.co.extreme.module.xsod.model.XsodOrderSession;
import jp.co.extreme.module.xsod.model.XsodSalesPack;
import jp.co.extreme.module.xsod.stub.XsodGeneralStub;
import jp.co.extreme.module.xsod.stub.XsodOrderSessionStub;
import jp.co.extreme.module.xsod.stub.XsodOrderStub;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf2.client.ScfFileDownloader;
import org.w3c.dom.Document;

public class XsodController {
    public Document dom;
    public String desktopMode;
    public int orientation = 0;
    public boolean isFullScreen;
    private String seatsCode;
    public XsodOrderSession orderSession;
    public XsodMenuData menuData;
    public String langCode;
    public int debugMode;

    private XsodController() {
        this.langCode = BcISO.ISO_639.Japanese.code;
    }

    public static XsodController getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public void setLangCode(String langCode) throws Exception {
        this.langCode = langCode;
        XsodEventHandler[] eventHandlers = EtcEventHandlerManager.getInstance().getEventHandlerList(XsodEventHandler.class).toArray(new XsodEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            try {
                XsodEventHandler eventHandler = eventHandlers[i];
                eventHandler.langChanged(langCode);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    public XsodOrderSession getOrderSession(boolean isCretae) throws Exception {
        if (this.orderSession == null) {
            this.orderSession = XsodOrderSessionStub.getInstance().gettOrderSession(this.seatsCode);
        }
        if (isCretae && this.orderSession == null) {
            this.orderSession = XsodOrderSessionStub.getInstance().createOrderSession(this.seatsCode);
        }
        return this.orderSession;
    }

    protected void initMenuData() throws Exception {
        BcLogUtil.info("\u30e1\u30cb\u30e5\u30fc\u30c7\u30fc\u30bf\u3092\u521d\u671f\u5316\u4e2d...");
        URL getUrl = new URL(String.valueOf(XsodSignageController.getInstance().baseUrl) + "getMenuData");
        BcLogUtil.info("\u30e1\u30cb\u30e5\u30fc\u30c7\u30fc\u30bf\u3092\u53d6\u5f97\u4e2d... URL=" + getUrl);
        HtclContentLoader contentLoader = new HtclContentLoader();
        ByteArrayOutputStream baos = contentLoader.getContent(getUrl);
        byte[] bytes = baos.toByteArray();
        BcLogUtil.info("JSON\u3092\u89e3\u6790\u4e2d... \u30b5\u30a4\u30ba=" + bytes.length);
        String jsonText = new String(bytes, BcCharsetNames.UTF_8.value);
        ObjectMapper objectMapper = new ObjectMapper();
        XsodMenuData menuData = (XsodMenuData)objectMapper.readValue(jsonText, XsodMenuData.class);
        BcLogUtil.info("\u30e1\u30cb\u30e5\u30fc\u30c7\u30fc\u30bf\u3092\u69cb\u6210\u4e2d...");
        this.setMenuData(menuData);
    }

    public XsodMenuData getMenuData() throws Exception {
        if (this.menuData == null) {
            this.initMenuData();
        }
        return this.menuData;
    }

    public void setMenuData(XsodMenuData menuData) throws Exception {
        this.menuData = menuData;
    }

    public void selectTop() throws Exception {
        XsodMenuData menuData = this.getMenuData();
        BcLogUtil.debug("menuData=" + menuData);
        BcLogUtil.debug("category1List=" + menuData.category1List);
        XsodDesktop.getInstance().customerPane.category1Pane.setCategoryList(menuData.category1List);
    }

    public void category1Selected(String categoryCode) throws Exception {
        List<XsodCategory> category2List = XsodUtil.createCategoryListByParentCode(this.menuData.category2List, categoryCode);
        XsodDesktop.getInstance().customerPane.category2Pane.setCategoryList(categoryCode, category2List);
    }

    public void category2Selected(String categoryCode) throws Exception {
        BcLogUtil.debug("category2Selected:categoryCode=" + categoryCode);
        XsodCategory category = this.menuData.categoryMap.get(categoryCode);
        List<String> merchandiseCodeList = EtcEnumStrUtil.toValueList(category.merchandiseCodes);
        XsodDesktop.getInstance().customerPane.menuDetailPane.setMerchandiseCodeList(merchandiseCodeList);
    }

    public void merchandiseSelected(String merchandiseCode) throws Exception {
        BcLogUtil.debug("itemSelected\uff1amerchandiseCode=" + merchandiseCode);
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        XsodMerchandisePack merchandisePack = XsodUtil.getMerchandisePackByItemCode(menuData, merchandiseCode);
        XsodOrder order = new XsodOrder();
        order.merchandiseCode = merchandisePack.merchandise.code;
        order.quantity = 1;
        this.addOrderPlan(order);
    }

    public void addOrderPlan(XsodOrder order) throws Exception {
        XsodDesktop.getInstance().customerPane.orderPlanListPane.addOrder(order);
    }

    public void confirmOrderFix(Collection<XsodOrder> orderCollection) throws Exception {
        XsodOrderPlanFixPane orderPlanFixPane = XsodDesktop.getInstance().customerPane.orderPlanFixPane;
        orderPlanFixPane.setData(orderCollection);
        XsodDesktop.getInstance().customerPane.setPopupNode((Node)orderPlanFixPane);
    }

    public void addOrderFix(Collection<XsodOrder> orderCollection) throws Exception {
        XsodOrderStub.getInstance().putOrderCollection(this.getOrderSession(true).getDataId(), orderCollection);
        XsodDesktop.getInstance().customerPane.orderPlanListPane.clear();
        XsodDesktop.getInstance().customerPane.customerTopPane.updateStaus();
    }

    public void orderHistory() throws Exception {
        XsodCondition condition = new XsodCondition();
        condition.sessionId = this.orderSession.getDataId();
        Object[] res = XsodOrderStub.getInstance().getCurrentOrderList(condition);
        List orderList = (List)res[0];
        List orderSessionList = (List)res[1];
        XsodOrderPlanFixPane orderHistoryPane = XsodDesktop.getInstance().customerPane.orderHistoryPane;
        orderHistoryPane.setData(orderList);
        XsodDesktop.getInstance().customerPane.setPopupNode((Node)orderHistoryPane);
    }

    public void billRequest() throws Exception {
        XsodSalesPack salesPack = XsodOrderStub.getInstance().bill_1(this.orderSession.getDataId());
        XsodBillFixPane billFixPane = XsodDesktop.getInstance().customerPane.billFixPane;
        billFixPane.setData(salesPack);
        XsodDesktop.getInstance().customerPane.setPopupNode((Node)billFixPane);
    }

    public void billFix() throws Exception {
        XsodSalesPack salesPack = XsodOrderStub.getInstance().bill_2(this.orderSession.getDataId());
        XsodDesktop.getInstance().customerPane.removePopup();
        BcLogUtil.info("\u304a\u4f1a\u8a08\u78ba\u5b9a\uff01!!!!");
    }

    public void callStaff() throws Exception {
        XsodDesktop.getInstance().customerPane.setPopupNode((Node)XsodDesktop.getInstance().customerPane.callingPane);
    }

    public void setupLocalProperty() throws Exception {
        String filePath = AfbApplication.getInstance().toReal("${APP}config/selfy.xml");
        File file = new File(filePath);
        BcLogUtil.debug("\u30ed\u30fc\u30ab\u30eb\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9=" + file.getPath());
        this.dom = BcXmlUtil.createDocument(file);
        this.desktopMode = BcXmlUtil.getTextValue(this.dom, "desktop/mode");
        String tmpStr = BcXmlUtil.getTextValue(this.dom, "desktop/orientation");
        if ("V".equalsIgnoreCase(tmpStr)) {
            this.orientation = 1;
        }
        tmpStr = BcXmlUtil.getTextValue(this.dom, "desktop/fullScreen");
        this.isFullScreen = BcBooleanUtil.parseBoolean(tmpStr);
        BcLogUtil.debug("\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u30e2\u30fc\u30c9=" + this.desktopMode + " \u5411\u304d=" + this.orientation + " \u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3=" + this.isFullScreen);
        this.seatsCode = BcXmlUtil.getTextValue(this.dom, "seatsCode");
        BcLogUtil.debug("\u30c6\u30fc\u30d6\u30eb\u756a\u53f7=" + this.seatsCode);
        String baseUrl = BcXmlUtil.getTextValue(this.dom, "baseUrl");
        BcLogUtil.debug("URL=" + baseUrl);
        XsodSignageController.getInstance().baseUrl = baseUrl = BcFileUtil.appendEndSlash(baseUrl);
        tmpStr = BcXmlUtil.getTextValue(this.dom, "desktop/orientation");
        this.debugMode = BcNumberUtil.parseInt(tmpStr, -1);
    }

    public void loadResource() throws Exception {
        File localFile;
        File svFile;
        BcLogUtil.info("\u30b5\u30fc\u30d0\u5074\u306e\u30ea\u30bd\u30fc\u30b9\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d...");
        if (!ScfClientContainer.getInstance().isClient()) {
            BcLogUtil.info("\u30b9\u30bf\u30f3\u30c9\u30a2\u30ed\u30f3\u306a\u306e\u3067\u5b9f\u884c\u3057\u306a\u3044");
            return;
        }
        File imageDir = XsodUtil.getImageDir();
        List<XfilUriEntity> uriEntityList = XsodUtil.getUriEntityList();
        Object[] res = XsodGeneralStub.getInstance().getFileList(uriEntityList);
        List updateFileList = (List)res[0];
        List deleteFileList = (List)res[1];
        BcMonitor monitor = new BcMonitor();
        int chunkSize = 0x100000;
        BcLogUtil.info("\u66f4\u65b0\u30d5\u30a1\u30a4\u30eb\u6570=" + updateFileList.size());
        int i = 0;
        while (i < updateFileList.size()) {
            svFile = (File)updateFileList.get(i);
            BcLogUtil.info("svFile=" + svFile.getPath());
            localFile = new File(imageDir, svFile.getName());
            BcLogUtil.info("localFile=" + localFile.getPath());
            ScfFileDownloader fileDownloader = new ScfFileDownloader(ScfClientContainer.getInstance().getAgent());
            fileDownloader.setChunkSize(chunkSize);
            fileDownloader.download(monitor, svFile, localFile, false);
            monitor.sync();
            ++i;
        }
        BcLogUtil.info("\u524a\u9664\u30d5\u30a1\u30a4\u30eb\u6570=" + deleteFileList.size());
        i = 0;
        while (i < deleteFileList.size()) {
            svFile = (File)deleteFileList.get(i);
            BcLogUtil.info("svFile=" + svFile.getPath());
            localFile = new File(imageDir, svFile.getName());
            BcLogUtil.info("localFile=" + localFile.getPath());
            BcFileUtil.deleteFile(localFile);
            ++i;
        }
    }

    /* synthetic */ XsodController(XsodController xsodController) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodController instance = new XsodController(null);

        private SingletonHolder() {
        }
    }
}

