/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.TablePosition;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxControlPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.model.Wbs1ArticleCondition;
import jp.co.extreme.module.xsod.fx.XsodClientUtil;
import jp.co.extreme.module.xsod.fx.XsodConditionSet;
import jp.co.extreme.module.xsod.rmo.XsodCategoryRMO;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf6.fx.JfxAabstractDataViewPane;
import jp.co.extreme.scf6.fx.JfxTableControlPane2;

public class XsodCategoryListPane
extends JfxAabstractDataViewPane {
    List<List> selectedrowList;

    public XsodCategoryListPane() throws Exception {
        Node conditionNode = this.createConditionNode(null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return "xxx";
    }

    @Override
    protected Node createConditionNode(Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XsodConditionSet personConditionSet = conditionPane.personConditionSet;
        conditionPane.addNodeUnit(personConditionSet.itemNameUnit);
        conditionPane.addNodeUnit(personConditionSet.addPeriodUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            personConditionSet.setConditionSet(preConditionPane.personConditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    public void clearCondition() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        conditionPane.personConditionSet.clear();
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        Wbs1ArticleCondition articleCondition = conditionPane.personConditionSet.getCondition();
        articleCondition.tableName = Wbs1Constants.ArticleCategory.article.tableName;
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XsodCategoryRMO.class.getName());
        rmiReq.setMethodName("merchandiseCategoryList");
        rmiReq.addData(articleCondition);
        return rmiReq;
    }

    @Override
    protected JfxTableControlPane2 createTableControlPane() throws Exception {
        InnerTableControlPaneExt tableOptionPane = new InnerTableControlPaneExt();
        return tableOptionPane;
    }

    @Override
    public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
        super.rowSelectionChanged(tableView, rowIdList, prevRowId, nextRowId);
        this.selectedrowList = FxTableUtil.createSelectedRowList(tableView, "xsod_category.code");
    }

    @Override
    public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
        super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
        if (doubleClicked) {
            this.openItem(this.selectedrowList);
        }
    }

    protected void openItem(Collection<List> rowCollection) throws Exception {
        for (List row : rowCollection) {
            String merchandiseCode = (String)row.get(0);
            XsodClientUtil.getInstance().openMerchandiseCategoryEditPane(merchandiseCode);
        }
    }

    class InnerConditionPane
    extends FxFlowPane {
        XsodConditionSet personConditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.personConditionSet = new XsodConditionSet();
        }
    }

    protected class InnerTableControlPaneExt
    extends JfxAabstractDataViewPane.InnerTableControlPane {
        FxButton addButton;
        FxButton openButton;

        public InnerTableControlPaneExt() throws Exception {
            super(XsodCategoryListPane.this);
        }

        @Override
        protected void initControl() throws Exception {
            super.initControl();
            super.setDisplaySettingButton(true);
            FxControlPane controlPane = this.getControlPane();
            this.addButton = new FxButton(BcWords.getInstance().add);
            this.addButton.setOnAction(this.actionEventHandler);
            this.addButton.setGraphic((Node)FxImageHelper.createImageView_icon("add_64x64.png"));
            controlPane.addControl(1, (Node)this.addButton);
            this.openButton = new FxButton(BcWords.getInstance().open);
            this.openButton.setOnAction(this.actionEventHandler);
            this.openButton.setGraphic((Node)FxImageHelper.createImageView_icon("deep_blue/folder_opened_256x256.png"));
            controlPane.addControl(1, (Node)this.openButton);
        }

        @Override
        protected void actionPerformed(ActionEvent ev) throws Exception {
            super.actionPerformed(ev);
            if (ev.getSource() == this.addButton) {
                XsodClientUtil.getInstance().openMerchandiseCategoryEditPane(null);
            } else if (ev.getSource() == this.openButton) {
                XsodCategoryListPane.this.openItem(XsodCategoryListPane.this.selectedrowList);
            }
        }
    }
}

