/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.dao.XdtsCustomSqlDAO;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XdtsCustomSqlRMO
extends RmiAbstractRMO {
    String namePrefix = "SQL-";

    public void putEntity(RmiRmoArgument rmoArg) throws Exception {
        XdtsCustomSql customSql = (XdtsCustomSql)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        customSql.name = BcStringUtil.trim(customSql.name);
        customSql.group = XdtsUtil.reformPath(customSql.group);
        XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        customSql.name = this.createName(dtsSession, customSql.profileId, customSql.getDataId(), customSql.name, this.namePrefix);
        XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
        rmoArg.getRespons().addData(customSql);
    }

    public void getEntity(RmiRmoArgument rmoArg) throws Exception {
        int entityId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, entityId);
        rmoArg.getRespons().addData(customSql);
    }

    public void deleteEntity(RmiRmoArgument rmoArg) throws Exception {
        Collection entityIdCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        XdtsCustomSql sustomSql = new XdtsCustomSql();
        int cnt = 0;
        for (Integer entityId : entityIdCollection) {
            sustomSql.setDataId(entityId);
            cnt += XdtsCustomSqlDAO.getInstance().deleteEntity(dtsSession, sustomSql);
        }
        rmoArg.getRespons().addData(cnt);
    }

    public void getCustomSqlList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List customSqlList = XdtsCustomSqlDAO.getInstance().getList(dtsSession, profileId);
        rmoArg.getRespons().addData(customSqlList);
    }

    public void copyCustomSql(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection customSqlIdCollection = (Collection)rmoArg.getRequest().getData();
        String group = rmoArg.getRequest().getDataAsString();
        this.getLogger().debug("copyCustomSql:profileId=" + profileId);
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ArrayList<XdtsCustomSql> customSqlList = new ArrayList<XdtsCustomSql>();
        Iterator iterator = customSqlIdCollection.iterator();
        while (iterator.hasNext()) {
            int customSqlId = (Integer)iterator.next();
            this.getLogger().debug("copyCustomSql:customSqlId=" + customSqlId);
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getById(dtsSession, customSqlId);
            this.getLogger().debug("customSql=" + customSql);
            customSql.profileId = profileId;
            customSql.name = this.createName(dtsSession, customSql.profileId, customSql.getDataId(), customSql.name, this.namePrefix);
            customSql.setObjectId(-1L);
            customSql.setDataId(-1);
            customSql.group = group;
            XdtsCustomSqlDAO.getInstance().putEntity(dtsSession, customSql);
            customSqlList.add(customSql);
        }
        rmoArg.getRespons().addData(customSqlList);
    }

    public String createName(DtsSession dtsSession, int profileId, int entityId, String origName, String namePrefix) throws Exception {
        if (BcStringUtil.isEmpty(origName)) {
            origName = String.valueOf(namePrefix) + entityId;
        }
        String newName = BcStringUtil.toStringNotNull(origName);
        String baseName = null;
        int tryCnt = 0;
        while (true) {
            XdtsCustomSql customSql = (XdtsCustomSql)XdtsCustomSqlDAO.getInstance().getByName(dtsSession, profileId, newName);
            this.getLogger().debug("newName=" + newName + " customSql=" + customSql);
            if (customSql == null || customSql.getDataId() == entityId) break;
            if (BcStringUtil.isEmpty(baseName) && BcStringUtil.isEmpty(baseName = EtcWordUtil.getBaseName(origName))) {
                baseName = origName;
            }
            newName = String.valueOf(baseName) + EtcEnumStrUtil.toElement(++tryCnt);
        }
        return newName;
    }

    public static enum Method implements RmiRemoteMethod
    {
        putEntity,
        getEntity,
        deleteEntity,
        getCustomSqlList,
        copyCustomSql;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

