/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdRenderingConverter;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;

public final class XdtsWordUtil {
    private XdtsWordUtil() {
    }

    public static BcTableModel createTable(Map<String, Map<String, String>> wordMap, Map<String, Map<String, MmdField>> mmdFieldMap) throws Exception {
        BcTableModel tableModel = BcTableUtil.createTableModelByHeaderValues("code", "lang", "word", "decimalDigits", "columnCount", "valueConverterClass", "formatPattern", "displayClassName", "horizonalAlignment", "renderingConverterClass", "decimalPointShift");
        for (Map.Entry<String, Map<String, String>> mapEntry1 : wordMap.entrySet()) {
            Map<String, String> wordMap2 = mapEntry1.getValue();
            Map<String, MmdField> mmdFieldMap2 = mmdFieldMap.get(mapEntry1.getKey());
            int cnt = 0;
            for (Map.Entry<String, String> mapEntry2 : wordMap2.entrySet()) {
                ++cnt;
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(mapEntry1.getKey());
                row.add(mapEntry2.getKey());
                String word = mapEntry2.getValue();
                if (!BcStringUtil.isEmpty(word)) {
                    word = mapEntry2.getValue().replace("\n", "").replace("\r", "");
                }
                row.add(word);
                MmdField mmdField = mmdFieldMap2.get(mapEntry2.getKey());
                if (mmdField != null) {
                    if (mmdField.decimalDigit > -1) {
                        row.add(mmdField.decimalDigit);
                    } else {
                        row.add(null);
                    }
                    if (mmdField.columnCount > -1) {
                        row.add(mmdField.columnCount);
                    } else {
                        row.add(null);
                    }
                    row.add(mmdField.valueConverterClassName);
                    row.add(mmdField.fieldDisplay.formatPattern);
                    row.add(mmdField.fieldDisplay.displayClassName);
                    MmdUtil.Alignment alignment = MmdUtil.Alignment.getById(mmdField.fieldDisplay.horizonalAlignment);
                    if (alignment != null && alignment != MmdUtil.Alignment.NULL) {
                        row.add(alignment.name());
                    } else {
                        row.add(null);
                    }
                    row.add(mmdField.fieldDisplay.renderingConverterClassName);
                    if (mmdField.fieldDisplay.shift != 0) {
                        row.add(mmdField.fieldDisplay.shift);
                    } else {
                        row.add(null);
                    }
                } else {
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                }
                tableModel.addRow(row);
            }
        }
        BcTableUtil.sort(tableModel, true, 0, 1, 2);
        BcLogUtil.debug("#1:tableModel.getRowCount()=" + tableModel.getRowCount());
        return tableModel;
    }

    public static void loadWordCsv(Map<String, Map<String, String>> wordMap, Map<String, Map<String, MmdField>> mmdFieldMap, File file) throws Exception {
        BcFileUtil.notEexistsException(file);
        BcCsvToTable csvToTable = new BcCsvToTable();
        BcTableModel tableModel = csvToTable.csvToTable(file, 1);
        BcLogUtil.debug("loadWordCsv:tableModel.getRowCount()=" + tableModel.getRowCount());
        int i = 0;
        while (i < tableModel.getRowCount()) {
            String code = (String)tableModel.getValueAt(i, 0);
            String lang = (String)tableModel.getValueAt(i, 1);
            String word = (String)tableModel.getValueAt(i, 2);
            HashMap<String, String> wordMap2 = new HashMap<String, String>();
            wordMap2.put(lang, word);
            wordMap.put(code, wordMap2);
            MmdField mmdField = new MmdField();
            String tmpStr = (String)tableModel.getValueAt(i, 3);
            mmdField.decimalDigit = BcNumberUtil.parseInteger(tmpStr, -1);
            tmpStr = (String)tableModel.getValueAt(i, 4);
            mmdField.columnCount = BcNumberUtil.parseInteger(tmpStr, -1);
            mmdField.valueConverterClassName = (String)tableModel.getValueAt(i, 5);
            mmdField.fieldDisplay.formatPattern = (String)tableModel.getValueAt(i, 6);
            mmdField.fieldDisplay.displayClassName = (String)tableModel.getValueAt(i, 7);
            tmpStr = (String)tableModel.getValueAt(i, 8);
            MmdUtil.Alignment alignment = BcLangUtil.getEnumByName(MmdUtil.Alignment.class, tmpStr, true);
            if (alignment != null) {
                mmdField.fieldDisplay.horizonalAlignment = alignment.id;
            }
            mmdField.fieldDisplay.renderingConverterClassName = (String)tableModel.getValueAt(i, 9);
            tmpStr = (String)tableModel.getValueAt(i, 10);
            mmdField.fieldDisplay.shift = BcNumberUtil.parseInteger(tmpStr, 0);
            XdtsWordUtil.setupMmdField(mmdField);
            HashMap<String, MmdField> mmdFieldMap2 = new HashMap<String, MmdField>();
            mmdFieldMap2.put(lang, mmdField);
            mmdFieldMap.put(code, mmdFieldMap2);
            ++i;
        }
    }

    public static void setupMmdField(MmdField mmdField) throws Exception {
        if (!BcStringUtil.isEmpty(mmdField.dataClassName)) {
            mmdField.dataClass = Class.forName(mmdField.dataClassName);
        }
        if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.displayClassName)) {
            try {
                mmdField.fieldDisplay.displayClass = Class.forName(mmdField.fieldDisplay.displayClassName);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.renderingConverterClassName)) {
            try {
                Class<?> clazz = Class.forName(mmdField.fieldDisplay.renderingConverterClassName);
                mmdField.fieldDisplay.renderingConverter = (MmdRenderingConverter)BcReflectUtil.getInstance(clazz);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

