/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.tbcp.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcDifference;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcTikaUtil;
import jp.co.extreme.module.tbcp.common.TbcpCellNull;
import jp.co.extreme.module.tbcp.common.TbcpCondition;
import jp.co.extreme.module.tbcp.common.TbcpTableComparator;
import jp.co.extreme.module.tbcp.common.TbcpTableToExcel;
import jp.co.extreme.module.tbcp.common.TbcpWords;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.poi.PoiCsvWriter4Table;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiUtil;
import jp.co.extreme.poi.PoiWorkbookUtil;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TbcpCsvComparator
extends BcLoggableObject {
    public static TbcpCellNull cellNull = new TbcpCellNull();
    protected BcCsvToTable csvToTable = new BcCsvToTable();
    public TbcpCondition condition;
    String title;

    public TbcpCsvComparator() {
        this.csvToTable.setFillValue(cellNull);
    }

    public BcResult compare(File file1, File file2) throws Exception {
        BcResult result = new BcResult();
        this.getLogger().info("file1=" + file1.getPath());
        this.getLogger().info("file2=" + file2.getPath());
        BcFileUtil.notEexistsMessage(file1, result.getErrorList());
        BcFileUtil.notEexistsMessage(file2, result.getErrorList());
        if (result.hasError()) {
            return result;
        }
        this.title = String.format("Difference between '%s' and '%s'.", file1.getName(), file2.getName());
        if (!this.checkFileType(file1)) {
            result.addError(String.format(TbcpWords.getInstance().$_is_not_a_text_file, "File1"));
            return result;
        }
        if (!this.checkFileType(file2)) {
            result.addError(String.format(TbcpWords.getInstance().$_is_not_a_text_file, "File2"));
            return result;
        }
        BcTableModel tableModel1 = this.csvToTable(file1);
        BcTableModel tableModel2 = this.csvToTable(file2);
        Map<String, BcDifference> diffMap = this.createDiffMap(tableModel1, tableModel2);
        if (this.condition.csv) {
            File destDir = new File(AfbApplication.getInstance().toReal("${APP}export/"));
            File destFile = BcFileUtil.add_yyyyMMdd_HHmmssSSS("differences.csv", destDir);
            this.getLogger().info(String.format("Creating Result CSV. file=%s", destFile.getPath()));
            BcFileUtil.makeParent(destFile);
            this.createResultCsv(diffMap, destFile);
        }
        if (this.condition.workbook) {
            XSSFWorkbook workbook1 = this.createWorkbook(tableModel1, diffMap, 0, this.condition);
            File destFile1 = null;
            destFile1 = this.condition.destFile1 == null ? new File(this.creatDestFilePath(file1)) : this.condition.destFile1;
            this.writeWorkbook(workbook1, destFile1);
            XSSFWorkbook workbook2 = this.createWorkbook(tableModel2, diffMap, 1, this.condition);
            File destFile2 = null;
            destFile2 = this.condition.destFile2 == null ? new File(this.creatDestFilePath(file2)) : this.condition.destFile2;
            this.writeWorkbook(workbook2, destFile2);
        }
        this.getLogger().info("Finished.");
        return result;
    }

    protected boolean checkFileType(File file) throws Exception {
        this.getLogger().info(String.format("Checking file type of %s.", file.getName()));
        return BcTikaUtil.isTextFile(file);
    }

    protected BcTableModel csvToTable(File file) throws Exception {
        this.getLogger().info(String.format("Reading file '%s'", file.getName()));
        this.csvToTable.setLogger(this.getLogger());
        BcTableModel tableModel = this.csvToTable.csvToTable(file, -1);
        this.getLogger().info(String.format("row=%s column=%s", tableModel.getRowCount(), tableModel.getColumnCount()));
        return tableModel;
    }

    protected Map<String, BcDifference> createDiffMap(BcTableModel tableModel1, BcTableModel tableModel2) throws Exception {
        TbcpTableComparator tableComparator = new TbcpTableComparator();
        tableComparator.setLogger(this.getLogger());
        this.getLogger().info("Comparing...");
        Map<String, BcDifference> diffMap = tableComparator.compare(tableModel1, tableModel2);
        this.getLogger().info(String.format("There are %d differences.", diffMap.size()));
        return diffMap;
    }

    protected XSSFWorkbook createWorkbook(BcTableModel tableModel, Map<String, BcDifference> diffMap, int tbaleIndex, TbcpCondition condition) throws Exception {
        TbcpTableToExcel tableToExcel = new TbcpTableToExcel();
        tableToExcel.setLogger(this.getLogger());
        tableToExcel.title = this.title;
        return tableToExcel.createWorkbook(tableModel, diffMap, tbaleIndex, condition);
    }

    protected void writeWorkbook(XSSFWorkbook workbook, File destFile) throws Exception {
        PoiWorkbookUtil.writeWorkbook((Workbook)workbook, destFile, this.getLogger());
    }

    protected String creatDestFilePath(File baseFile) throws Exception {
        File destFileTmp = BcFileUtil.replaceExtention(baseFile, PoiConstants.Extention.xlsx.name());
        File destFile = BcFileUtil.add_yyyyMMdd_HHmmssSSS(destFileTmp.getName(), destFileTmp.getParentFile());
        return destFile.getPath();
    }

    protected void createResultCsv(Map<String, BcDifference> diffMap, File destFile) throws Exception {
        BcTableModel tableModel = BcTableUtil.createTableModelByHeaderValues("No.", "Row Index", "Column Index", "Value-1", "Value-2", "Indexes");
        for (Map.Entry<String, BcDifference> mapEntry : diffMap.entrySet()) {
            BcDifference difference = mapEntry.getValue();
            int[] values = TbcpTableComparator.toValues(mapEntry.getKey());
            ArrayList<String> row = new ArrayList<String>();
            row.add(null);
            row.add(Integer.toString(values[0]));
            row.add(Integer.toString(values[1]));
            row.add(BcStringUtil.toString(difference.value1));
            row.add(BcStringUtil.toString(difference.value2));
            List nounList = null;
            if (difference != null) {
                nounList = (List)difference.arrayInfo;
            }
            if (BcCollectionUtil.isEmpty(nounList)) {
                row.add(null);
            } else {
                row.add(this.createDifferenceIndex(nounList));
            }
            tableModel.addRow(row);
        }
        BcTableUtil.sort(tableModel, true, 1, 2);
        int i = 0;
        while (i < tableModel.getRowCount()) {
            tableModel.setValueAt(Integer.toString(i + 1), i, 0);
            ++i;
        }
        PoiExportCondition exportCondition = PoiUtil.createExportCondition();
        PoiCsvWriter4Table csvWriter4Table = new PoiCsvWriter4Table();
        csvWriter4Table.writeTable(exportCondition, tableModel.getTableColumnModel(), tableModel, destFile);
    }

    protected String createDifferenceIndex(List<NlpNoun> nounList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < nounList.size()) {
            NlpNoun noun = nounList.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(noun.beginIndex) + "-" + noun.endIndex);
            ++i;
        }
        return sb.toString();
    }
}

