/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mqsv.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Vector;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.xml.BcXmlUtil;
import jp.co.extreme.module.mqsv.common.MqsvMessage;
import jp.co.extreme.module.mqsv.common.MqsvMessageListenerContext;
import jp.co.extreme.module.mqsv.server.MqsvService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MqsvSendThread
extends Thread {
    protected BcMonitor threadMon = new BcMonitor();
    protected boolean isStop;
    protected MqsvService msgService;
    protected MqsvMessageListenerContext msgListenerContext;
    protected Vector<MqsvMessage> msgList = new Vector();
    protected File saveDir;

    public MqsvSendThread(MqsvService msgService) {
        this.msgService = msgService;
        this.setPriority(1);
        this.start();
        this.threadMon.lock();
    }

    public void setMessageListenerContext(MqsvMessageListenerContext msgListenerContext) throws Exception {
        if (this.msgListenerContext != null && this.msgListenerContext.socket != null) {
            try {
                this.msgListenerContext.socket.close();
            }
            catch (Exception ex) {
                BcLogUtil.debug(ex);
            }
        }
        this.msgListenerContext = msgListenerContext;
        String filePath = AfbApplication.getInstance().getAppDirectry() + "/log/jsb_notice.log";
        BcLogger logger = BcLogUtil.createLogger("jsb_notice", false, true);
        BcLogUtil.addFileFileHandler(logger, new File(filePath));
        String saveDirPath = AfbApplication.getInstance().toReal(String.valueOf(this.msgService.tempDataDirPath) + "/" + msgListenerContext.address + "_" + msgListenerContext.port);
        this.saveDir = new File(saveDirPath);
        this.saveDir.mkdirs();
    }

    public MqsvMessageListenerContext getMessageListenerContext() {
        return this.msgListenerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(MqsvMessage msg) {
        Vector<MqsvMessage> vector = this.msgList;
        synchronized (vector) {
            this.msgList.add(msg);
            if (this.msgService.logLevel > 0) {
                BcLogUtil.debug("Message Service:'" + this.msgListenerContext.address + "_" + this.msgListenerContext.port + "' \u3078\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u30ad\u30e5\u30fc\u306b meaasageId='" + msg.uuid + "' \u304c\u8ffd\u52a0\u3055\u308c\u307e\u3057\u305f\u3002");
            }
            String[] fileNameList = this.saveDir.list();
            if (this.msgList.size() > this.msgListenerContext.dataCashMax || fileNameList.length > 0) {
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :\u30e1\u30c3\u30bb\u30fc\u30b8\u30ad\u30e5\u30fc\u306e\u30ad\u30e3\u30c3\u30b7\u30e5\u4ef6\u6570\u4e0a\u9650(" + this.msgListenerContext.dataCashMax + ")\u306b\u9054\u3057\u305f\u305f\u3081\uff28\uff24\uff24\u306b\u9000\u907f\u3057\u307e\u3059\u3002");
                }
                try {
                    int i = 0;
                    while (i < this.msgList.size()) {
                        MqsvMessage msg2 = this.msgList.get(i);
                        File file = new File(String.valueOf(this.saveDir.getPath()) + "/" + msg2.uuid + ".xml");
                        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), false);
                        this.msgService.outputMessage(fileOutputStream, msg2, true);
                        fileOutputStream.close();
                        ++i;
                    }
                    this.msgList.clear();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }
        this.threadMon.unLock();
    }

    public void stopThread() {
        this.isStop = true;
        this.msgList.clear();
    }

    @Override
    public void run() {
        while (!this.isStop) {
            this.threadMon.sync();
            this.run2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run2() {
        if (this.msgService.logLevel > 0) {
            BcLogUtil.info("Message Service:---- '" + this.msgListenerContext.address + "_" + this.msgListenerContext.port + "' ----");
        }
        MqsvMessage msg = null;
        File file = null;
        Vector<MqsvMessage> vector = this.msgList;
        synchronized (vector) {
            Object[] fileNameList = this.saveDir.list();
            if (fileNameList.length > 0) {
                Arrays.sort(fileNameList);
                file = new File(String.valueOf(this.saveDir.getPath()) + "/" + (String)fileNameList[0]);
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :\u9000\u907f\u4e2d\u306e\u30e1\u30c3\u30bb\u30fc\u30b8(" + fileNameList.length + "\u4ef6)\u304b\u3089 '" + file.getName() + "' \u3092\u9001\u4fe1\u3057\u307e\u3059\u3002");
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    byte[] byteArray = BcStreamUtil.read(is);
                    is.close();
                    msg = new MqsvMessage("", byteArray);
                    msg.uuid = BcFileUtil.getBaseName(file.getName());
                }
                catch (Exception ex) {
                    BcLogUtil.debug(ex);
                }
            } else if (this.msgList.size() > 0) {
                msg = this.msgList.get(0);
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :\u30e1\u30e2\u30ea\u30ad\u30e3\u30c3\u30b7\u30e5\u4e2d\u306e\u30e1\u30c3\u30bb\u30fc\u30b8(" + this.msgList.size() + "\u4ef6)\u304b\u3089 '" + msg.uuid + "' \u3092\u9001\u4fe1\u3057\u307e\u3059\u3002");
                }
            }
        }
        if (msg == null) {
            this.threadMon.lock();
            return;
        }
        int tryCount = 0;
        while (true) {
            ++tryCount;
            if (this.msgService.logLevel > 0) {
                BcLogUtil.debug("               :tryCount=" + tryCount);
            }
            boolean success = false;
            try {
                success = this.sessionTrans(msg);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            if (success) {
                try {
                    if (file != null) {
                        file.delete();
                        break;
                    }
                    this.msgList.remove(msg);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                break;
            }
            if (this.msgListenerContext.retryMax >= 0 && tryCount > this.msgListenerContext.retryMax) {
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :\u30ea\u30c8\u30e9\u30a4\u56de\u6570\u4e0a\u9650(" + this.msgListenerContext.retryMax + ")\u3092\u8d85\u3048\u305f\u305f\u3081\u30ea\u30c8\u30e9\u30a4\u3092\u505c\u6b62\u3057\u307e\u3059\u3002");
                }
                this.threadMon.lock();
                break;
            }
            int retryWaitMilliSec = this.msgListenerContext.retryWaitMilliSec;
            if (retryWaitMilliSec < 100) {
                retryWaitMilliSec = 100;
            }
            if (this.msgService.logLevel > 0) {
                BcLogUtil.info("               :" + retryWaitMilliSec + " \u30df\u30ea\u79d2\u30b9\u30ec\u30c3\u30c9\u3092\u5f85\u6a5f\u3057\u307e\u3059\u3002");
            }
            try {
                Thread.sleep(retryWaitMilliSec);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    protected boolean sessionTrans(MqsvMessage msg) throws Exception {
        boolean sessionSuccess;
        boolean sendSuccess;
        block21: {
            block20: {
                sendSuccess = false;
                sessionSuccess = false;
                if (this.msgListenerContext.socket != null) {
                    try {
                        this.msgService.outputMessage(this.msgListenerContext.socket.getOutputStream(), msg, false);
                        sendSuccess = true;
                    }
                    catch (Exception ex) {
                        BcLogUtil.debug(ex);
                        this.msgListenerContext.socket = null;
                        if (this.msgService.logLevel <= 0) break block20;
                        BcLogUtil.info("               :\u65e2\u5b58\u306e\u30bd\u30b1\u30c3\u30c8\u306b\u5bfe\u3059\u308b\u30c7\u30fc\u30bf\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    }
                }
            }
            if (this.msgListenerContext.socket == null) {
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :\u30bd\u30b1\u30c3\u30c8\u63a5\u7d9a\u3092\u8a66\u307f\u307e\u3059\u3002");
                }
                try {
                    this.msgListenerContext.socket = new Socket(this.msgListenerContext.address, this.msgListenerContext.port);
                    this.msgService.outputMessage(this.msgListenerContext.socket.getOutputStream(), msg, false);
                    sendSuccess = true;
                }
                catch (Exception ex) {
                    if (this.msgService.logLevel <= 0) break block21;
                    BcLogUtil.info("               :\u30bd\u30b1\u30c3\u30c8\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
        if (sendSuccess) {
            if (this.msgService.logLevel > 0) {
                BcLogUtil.info("               :  \u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
            }
            Document resXmlDoc = null;
            this.msgListenerContext.socket.setSoTimeout(this.msgListenerContext.soTimeoutMilliSec);
            byte[] byteArray = BcStreamUtil.read(this.msgListenerContext.socket.getInputStream());
            if (this.msgService.logLevel > 0) {
                BcLogUtil.info("               :\u30ec\u30b9\u30dd\u30f3\u30b9\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            inputSource.setEncoding("SJIS");
            resXmlDoc = BcXmlUtil.createDocument(inputSource);
            if (this.msgService.logLevel > 0) {
                BcLogUtil.debug(BcXmlUtil.toString(resXmlDoc, BcConstants.charset.name(), true));
            }
            Element rootElem = resXmlDoc.getDocumentElement();
            if (rootElem.getNodeName().equals("respons")) {
                String status = BcXmlUtil.getTextValue(rootElem, "status", null);
                String messageId = BcXmlUtil.getTextValue(rootElem, "messageId", "");
                if (this.msgService.logLevel > 0) {
                    BcLogUtil.info("               :  status='" + status + "'");
                    BcLogUtil.info("               :  messageId='" + messageId + "'");
                }
                if (Boolean.parseBoolean(status)) {
                    if (messageId.equals(msg.uuid)) {
                        sessionSuccess = true;
                    } else if (this.msgService.logLevel > 0) {
                        BcLogUtil.info("               :messageId \u304c\u7570\u306a\u308a\u307e\u3059\u3002");
                    }
                }
            } else {
                throw new Exception("unknown root tag:name='" + rootElem.getNodeName() + "'");
            }
        }
        return sessionSuccess;
    }
}

