/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import java.io.File;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerFactory;
import jp.co.extreme.base.log.BcLoggerLog4j;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;

public class BcLoggerFactoryLog4j
implements BcLoggerFactory {
    private Configuration configuration;
    private LoggerContext loggerContext;
    private Logger l4RootLogger;
    private LoggerConfig loggerConfigRoot;
    String format = "%d{yyyy/MM/dd HH:mm:ss.SSS} %-5p %c{1} - %m%n";

    public BcLoggerFactoryLog4j() {
        LogManager.setFactory(new Log4jContextFactory());
        StatusLogger.getLogger().setLevel(Level.OFF);
        this.loggerContext = (LoggerContext)LogManager.getContext(false);
        this.configuration = this.loggerContext.getConfiguration();
        this.l4RootLogger = this.loggerContext.getRootLogger();
        this.loggerConfigRoot = this.configuration.getRootLogger();
        BcLoggerFactoryLog4j.setAllLevels("", Level.INFO);
        this.removeAllAppender(this.l4RootLogger.getName());
    }

    @Override
    public BcLogger createLogger(String loggerName, boolean isAdditive, boolean consoleEnabled) throws Exception {
        Logger l4Logger;
        System.out.println("createLogger:loggerName=" + loggerName);
        BcLoggerLog4j loggerLog4j = (BcLoggerLog4j)BcLogUtil.loggerMap.get(loggerName);
        if (loggerLog4j == null) {
            l4Logger = this.getLogger(loggerName);
            l4Logger.setAdditive(isAdditive);
            loggerLog4j = new BcLoggerLog4j();
            loggerLog4j.setL4Logger(l4Logger);
        } else {
            l4Logger = (Logger)loggerLog4j.getL4Logger();
        }
        this.removeAllAppender(l4Logger.getName());
        if (consoleEnabled) {
            this.addConsoleAppender(l4Logger, AppenderName.CONSOLE.name(), this.format);
        }
        return loggerLog4j;
    }

    @Override
    public void addFileFileHandler(BcLogger logger, File destFile) throws Exception {
        BcLoggerLog4j loggerLog4j = (BcLoggerLog4j)logger;
        Logger l4Logger = (Logger)loggerLog4j.getL4Logger();
        System.out.println("destFile=" + destFile.getPath());
        BcFileUtil.writeableCheck(destFile);
        this.addFileAppender(l4Logger, AppenderName.FILE.name(), this.format, destFile);
    }

    public static Level tol4Level(BcLogConstants.LogLevel logLevel) {
        Level l4Level = null;
        switch (logLevel) {
            case OFF: {
                l4Level = Level.OFF;
            }
            case FATAL: {
                l4Level = Level.FATAL;
                break;
            }
            case ERROR: {
                l4Level = Level.ERROR;
                break;
            }
            case WARN: {
                l4Level = Level.WARN;
                break;
            }
            case INFO: {
                l4Level = Level.INFO;
                break;
            }
            case DEBUG: {
                l4Level = Level.DEBUG;
                break;
            }
            case TRACE: {
                l4Level = Level.TRACE;
                break;
            }
            case ALL: {
                l4Level = Level.ALL;
            }
        }
        return l4Level;
    }

    public static BcLogConstants.LogLevel toLogLevel(Level l4Level) {
        BcLogConstants.LogLevel logLevel = null;
        if (l4Level == Level.OFF) {
            logLevel = BcLogConstants.LogLevel.OFF;
        } else if (l4Level == Level.FATAL) {
            logLevel = BcLogConstants.LogLevel.FATAL;
        } else if (l4Level == Level.ERROR) {
            logLevel = BcLogConstants.LogLevel.ERROR;
        } else if (l4Level == Level.WARN) {
            logLevel = BcLogConstants.LogLevel.WARN;
        } else if (l4Level == Level.INFO) {
            logLevel = BcLogConstants.LogLevel.INFO;
        } else if (l4Level == Level.DEBUG) {
            logLevel = BcLogConstants.LogLevel.DEBUG;
        } else if (l4Level == Level.TRACE) {
            logLevel = BcLogConstants.LogLevel.TRACE;
        } else if (l4Level == Level.ALL) {
            logLevel = BcLogConstants.LogLevel.ALL;
        }
        return logLevel;
    }

    public static void setAllLevels(String parentLoggerName, Level level) {
        Configurator.setAllLevels(parentLoggerName, level);
    }

    public void removeAppender(LoggerConfig loggerConfig, String appenderName) {
        loggerConfig.removeAppender(appenderName);
        this.loggerContext.updateLoggers();
    }

    public void removeAllAppender(String loggerName) {
        Logger logger = (Logger)LogManager.getLogger(loggerName);
        LoggerConfig loggerConfig = this.configuration.getLoggerConfig(logger.getName());
        for (String appenderName : logger.getAppenders().keySet()) {
            this.removeAppender(loggerConfig, appenderName);
        }
    }

    public Logger getl4RootLogger() {
        return this.l4RootLogger;
    }

    public Logger getLogger(String loggerName) {
        return (Logger)LogManager.getLogger(loggerName);
    }

    public void addConsoleAppender(Logger logger, String appenderName, String layout) {
        ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((AbstractAppender.Builder)ConsoleAppender.newBuilder()).setName(appenderName)).setLayout(PatternLayout.newBuilder().withPattern(layout).build())).build();
        consoleAppender.start();
        this.configuration.addAppender(consoleAppender);
        logger.addAppender(consoleAppender);
        this.loggerContext.updateLoggers();
    }

    public void addFileAppender(Logger logger, String appenderName, String layout, File destFile) {
        RollingFileAppender rollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((AbstractAppender.Builder)RollingFileAppender.newBuilder()).setName(appenderName)).withAppend(true)).withFileName(destFile.getPath())).setLayout(PatternLayout.newBuilder().withPattern(layout).build())).setConfiguration(this.configuration)).withFilePattern(String.valueOf(destFile.getPath()) + ".%d{yyyyMMdd}.txt")).withCreateOnDemand(false)).withPolicy(TimeBasedTriggeringPolicy.createPolicy("1", "true"))).withStrategy(DefaultRolloverStrategy.createStrategy(null, null, "nomax", null, null, false, this.configuration))).build();
        rollingFileAppender.start();
        logger.addAppender(rollingFileAppender);
        this.loggerContext.updateLoggers();
    }

    public static enum AppenderName {
        CONSOLE,
        FILE;

    }
}

