/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.awt;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.co.extreme.base.log.BcLogUtil;

public class AwtImage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3245447093812580598L;
    protected Image image;

    public AwtImage() {
    }

    public AwtImage(Image image) {
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        if (this.image == null) {
            return;
        }
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        os.writeInt(width);
        os.writeInt(height);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            BcLogUtil.error(ex);
        }
        os.writeObject(pixels);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        int width = is.readInt();
        int height = is.readInt();
        int[] pixels = (int[])is.readObject();
        MemoryImageSource memoryImageSource = new MemoryImageSource(width, height, pixels, 0, width);
        this.image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public Object clone() {
        AwtImage obj = new AwtImage();
        obj.image = this.image;
        return obj;
    }
}

