/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationEvent;
import jp.co.extreme.app.common.AfbApplicationEventHandler;
import jp.co.extreme.app.common.AfbApplicationSetup;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.util.BcExceptionHandler;
import jp.co.extreme.base.util.BcExceptionUtil;
import jp.co.extreme.base.util.BcLocaleUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import org.apache.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AfbApplicationSetupProxy
extends BcLoggableObject {
    protected AfbApplication application;

    public void start(AfbApplication application, Node baseNode) throws Exception {
        this.application = application;
        this.getLogger().info("AfbApplicationSetupProxy.setup:baseDomNode=" + baseNode);
        if (baseNode != null) {
            this.exceptionHandlerSetting(baseNode);
        }
        if (baseNode != null) {
            this.eventHandlerSetting(baseNode);
        }
        application.fireEvent(new AfbApplicationEvent(this, 11));
        this.generalConfigSetup();
        this.fileAliasMapSetup();
        AfbApplicationSetup applicationSetup = null;
        if (application.setupClass != null) {
            applicationSetup = (AfbApplicationSetup)BcReflectUtil.getInstance(application.setupClass);
            applicationSetup.setup(application);
        }
        this.getLogger().info("\n" + BcStringUtil.fill("*", 78) + "\n" + "Talisker" + " setup completed." + "\n" + BcStringUtil.fill("*", 78));
        application.fireEvent(new AfbApplicationEvent(this, 12));
        if (applicationSetup != null) {
            applicationSetup.start(application);
        }
        application.fireEvent(new AfbApplicationEvent(this, 21));
    }

    protected void generalConfigSetup() throws Exception {
        String filePath = this.application.toReal("${APP}config/general.xml");
        File file = new File(filePath);
        Document generalConfig = null;
        if (file.exists()) {
            generalConfig = BcXmlUtil.createDocument(file);
        } else {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            generalConfig = documentBuilder.newDocument();
            Element rootElem = generalConfig.createElement("config");
            generalConfig.appendChild(rootElem);
            BcXmlUtil.setTextValue(rootElem, "logLevel", Level.INFO.toString());
            BcXmlUtil.output(generalConfig, file, true);
        }
        this.application.setGeneralConfig(generalConfig);
        String tmpStr = BcXmlUtil.getTextValue(generalConfig, AfbConstants.LogAttribute.logLevel.name());
        BcLogConstants.LogLevel logLevel = BcLogUtil.parseLogLevel(tmpStr, BcLogUtil.logLevelDefault);
        BcLogger logger = BcLogUtil.getLogger("");
        logger.setLogLevel(logLevel);
        tmpStr = BcXmlUtil.getTextValue(generalConfig, "langageCode");
        BcLocaleUtil.setLangage(tmpStr);
        tmpStr = BcXmlUtil.getTextValue(generalConfig, "debug");
        this.application.isDebug = BcBooleanUtil.parseBoolean(tmpStr);
        logger.debug("isDebug=" + this.application.isDebug);
    }

    protected void exceptionHandlerSetting(Node baseNode) throws Exception {
        Node domNode2 = BcXmlUtil.getNode(baseNode, "exceptionHandler");
        if (domNode2 == null) {
            return;
        }
        NodeList domNodeList = domNode2.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode3 = domNodeList.item(i);
            if (domNode3.getNodeName().equals("class")) {
                String className = BcXmlUtil.getTextValue(domNode3, null);
                Class<?> clazz = Class.forName(className);
                this.getLogger().info("exceptionHandler=" + className);
                BcExceptionHandler exceptionHandler = (BcExceptionHandler)BcReflectUtil.getInstance(clazz);
                BcExceptionUtil.setExceptionHandler(exceptionHandler);
            }
            ++i;
        }
    }

    protected void eventHandlerSetting(Node baseNode) throws Exception {
        Node domNode2 = BcXmlUtil.getNode(baseNode, "applicationEventHandler");
        if (domNode2 == null) {
            return;
        }
        NodeList domNodeList = domNode2.getChildNodes();
        int i = 0;
        while (i < domNodeList.getLength()) {
            Node domNode3 = domNodeList.item(i);
            if (domNode3.getNodeName().equals("class")) {
                String className = BcXmlUtil.getTextValue(domNode3, null);
                Class<?> clazz = Class.forName(className);
                AfbApplicationEventHandler applicationEventHandler = (AfbApplicationEventHandler)BcReflectUtil.getInstance(clazz);
                this.application.addApplicationEventHandler(applicationEventHandler);
            }
            ++i;
        }
    }

    public void fileAliasMapSetup() throws Exception {
        String filePath = this.application.toReal("${COMMON}config/file_alias.xml");
        File xmlFile = new File(filePath);
        if (!xmlFile.exists()) {
            return;
        }
        Document dom = BcXmlUtil.createDocument(xmlFile);
        Element documentElement = dom.getDocumentElement();
        NodeList nodeList = documentElement.getChildNodes();
        Map<String, String> fileAliasMap = this.application.getFileAliasMap();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("alias")) {
                String name = BcXmlUtil.getTextValue(node, "name");
                String value = BcXmlUtil.getTextValue(node, "value");
                this.getLogger().debug("name=" + name + " value=" + value);
                fileAliasMap.put(name, value);
            }
            ++i;
        }
    }
}

