/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder2;
import sun.awt.windows.WToolkit;
import sun.misc.ThreadGroupUtils;
import sun.util.logging.PlatformLogger;

public class Win32ShellFolderManager2
extends ShellFolderManager {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.shell.Win32ShellFolderManager2");
    private static final int VIEW_LIST = 2;
    private static final int VIEW_DETAILS = 3;
    private static final int VIEW_PARENTFOLDER = 8;
    private static final int VIEW_NEWFOLDER = 11;
    private static final Image[] STANDARD_VIEW_BUTTONS;
    private static Win32ShellFolder2 desktop;
    private static Win32ShellFolder2 drives;
    private static Win32ShellFolder2 recent;
    private static Win32ShellFolder2 network;
    private static Win32ShellFolder2 personal;
    private static File[] roots;
    private static List topFolderList;

    @Override
    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        try {
            return Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), file);
        }
        catch (InterruptedException interruptedException) {
            throw new FileNotFoundException("Execution was interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Win32ShellFolder2 createShellFolder(Win32ShellFolder2 win32ShellFolder2, File file) throws FileNotFoundException, InterruptedException {
        long l;
        try {
            l = win32ShellFolder2.parseDisplayName(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            l = 0L;
        }
        if (l == 0L) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        try {
            Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(win32ShellFolder2, l);
            return win32ShellFolder22;
        }
        finally {
            Win32ShellFolder2.releasePIDL(l);
        }
    }

    static Win32ShellFolder2 createShellFolderFromRelativePIDL(Win32ShellFolder2 win32ShellFolder2, long l) throws InterruptedException {
        long l2;
        while (l != 0L && (l2 = Win32ShellFolder2.copyFirstPIDLEntry(l)) != 0L) {
            win32ShellFolder2 = Win32ShellFolder2.createShellFolder(win32ShellFolder2, l2);
            l = Win32ShellFolder2.getNextPIDLEntry(l);
        }
        return win32ShellFolder2;
    }

    private static Image getStandardViewButton(int n) {
        Image image = STANDARD_VIEW_BUTTONS[n];
        if (image != null) {
            return image;
        }
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        bufferedImage.setRGB(0, 0, 16, 16, Win32ShellFolder2.getStandardViewButton0(n), 0, 16);
        Win32ShellFolderManager2.STANDARD_VIEW_BUTTONS[n] = bufferedImage;
        return bufferedImage;
    }

    static Win32ShellFolder2 getDesktop() {
        block4: {
            if (desktop == null) {
                try {
                    desktop = new Win32ShellFolder2(0);
                }
                catch (SecurityException securityException) {
                }
                catch (IOException | InterruptedException exception) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) break block4;
                    log.warning("Cannot access 'Desktop'", exception);
                }
            }
        }
        return desktop;
    }

    static Win32ShellFolder2 getDrives() {
        block4: {
            if (drives == null) {
                try {
                    drives = new Win32ShellFolder2(17);
                }
                catch (SecurityException securityException) {
                }
                catch (IOException | InterruptedException exception) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) break block4;
                    log.warning("Cannot access 'Drives'", exception);
                }
            }
        }
        return drives;
    }

    static Win32ShellFolder2 getRecent() {
        block5: {
            if (recent == null) {
                try {
                    String string = Win32ShellFolder2.getFileSystemPath(8);
                    if (string != null) {
                        recent = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException | InterruptedException exception) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) break block5;
                    log.warning("Cannot access 'Recent'", exception);
                }
            }
        }
        return recent;
    }

    static Win32ShellFolder2 getNetwork() {
        block4: {
            if (network == null) {
                try {
                    network = new Win32ShellFolder2(18);
                }
                catch (SecurityException securityException) {
                }
                catch (IOException | InterruptedException exception) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) break block4;
                    log.warning("Cannot access 'Network'", exception);
                }
            }
        }
        return network;
    }

    static Win32ShellFolder2 getPersonal() {
        block7: {
            if (personal == null) {
                try {
                    String string = Win32ShellFolder2.getFileSystemPath(5);
                    if (string != null) {
                        Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                        personal = win32ShellFolder2.getChildByPath(string);
                        if (personal == null) {
                            personal = Win32ShellFolderManager2.createShellFolder(Win32ShellFolderManager2.getDesktop(), new File(string));
                        }
                        if (personal != null) {
                            personal.setIsPersonal();
                        }
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException | InterruptedException exception) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) break block7;
                    log.warning("Cannot access 'Personal'", exception);
                }
            }
        }
        return personal;
    }

    @Override
    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getPersonal();
            if (win32ShellFolder2 == null) {
                win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            }
            return Win32ShellFolderManager2.checkFile(win32ShellFolder2);
        }
        if (string.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
                roots = win32ShellFolder2 != null ? new File[]{win32ShellFolder2} : (File[])super.get(string);
            }
            return Win32ShellFolderManager2.checkFiles(roots);
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDesktop();
            if (win32ShellFolder2 != null && Win32ShellFolderManager2.checkFile(win32ShellFolder2) != null) {
                ArrayList<File> arrayList = new ArrayList<File>();
                Win32ShellFolder2 win32ShellFolder22 = Win32ShellFolderManager2.getDrives();
                Win32ShellFolder2 win32ShellFolder23 = Win32ShellFolderManager2.getRecent();
                if (win32ShellFolder23 != null && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_2000) >= 0) {
                    arrayList.add(win32ShellFolder23);
                }
                arrayList.add(win32ShellFolder2);
                Object[] objectArray = Win32ShellFolderManager2.checkFiles(win32ShellFolder2.listFiles());
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    File[] fileArray;
                    Win32ShellFolder2 win32ShellFolder24 = (Win32ShellFolder2)object;
                    if (win32ShellFolder24.isFileSystem() && (!win32ShellFolder24.isDirectory() || win32ShellFolder24.isLink())) continue;
                    arrayList.add(win32ShellFolder24);
                    if (!win32ShellFolder24.equals(win32ShellFolder22) || (fileArray = Win32ShellFolderManager2.checkFiles(win32ShellFolder24.listFiles())) == null || fileArray.length <= 0) continue;
                    List<File> list = Arrays.asList(fileArray);
                    win32ShellFolder24.sortChildren(list);
                    arrayList.addAll(list);
                }
                return Win32ShellFolderManager2.checkFiles(arrayList);
            }
            return super.get(string);
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            Object object;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ArrayList<File> arrayList = new ArrayList<File>();
            int n = 0;
            do {
                object = toolkit.getDesktopProperty("win.comdlg.placesBarPlace" + n++);
                try {
                    if (object instanceof Integer) {
                        arrayList.add(new Win32ShellFolder2((Integer)object));
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    arrayList.add(this.createShellFolder(new File((String)object)));
                }
                catch (IOException iOException) {
                    if (!log.isLoggable(PlatformLogger.Level.WARNING)) continue;
                    log.warning("Cannot read value = " + object, iOException);
                }
                catch (InterruptedException interruptedException) {
                    if (log.isLoggable(PlatformLogger.Level.WARNING)) {
                        log.warning("Cannot read value = " + object, interruptedException);
                    }
                    return new File[0];
                }
            } while (object != null);
            if (arrayList.size() == 0) {
                for (File file : new File[]{Win32ShellFolderManager2.getRecent(), Win32ShellFolderManager2.getDesktop(), Win32ShellFolderManager2.getPersonal(), Win32ShellFolderManager2.getDrives(), Win32ShellFolderManager2.getNetwork()}) {
                    if (file == null) continue;
                    arrayList.add(file);
                }
            }
            return Win32ShellFolderManager2.checkFiles(arrayList);
        }
        if (string.startsWith("fileChooserIcon ")) {
            int n;
            String string2 = string.substring(string.indexOf(" ") + 1);
            if (string2.equals("ListView") || string2.equals("ViewMenu")) {
                n = 2;
            } else if (string2.equals("DetailsView")) {
                n = 3;
            } else if (string2.equals("UpFolder")) {
                n = 8;
            } else if (string2.equals("NewFolder")) {
                n = 11;
            } else {
                return null;
            }
            return Win32ShellFolderManager2.getStandardViewButton(n);
        }
        if (string.startsWith("optionPaneIcon ")) {
            Win32ShellFolder2.SystemIcon systemIcon;
            if (string == "optionPaneIcon Error") {
                systemIcon = Win32ShellFolder2.SystemIcon.IDI_ERROR;
            } else if (string == "optionPaneIcon Information") {
                systemIcon = Win32ShellFolder2.SystemIcon.IDI_INFORMATION;
            } else if (string == "optionPaneIcon Question") {
                systemIcon = Win32ShellFolder2.SystemIcon.IDI_QUESTION;
            } else if (string == "optionPaneIcon Warning") {
                systemIcon = Win32ShellFolder2.SystemIcon.IDI_EXCLAMATION;
            } else {
                return null;
            }
            return Win32ShellFolder2.getSystemIcon(systemIcon);
        }
        if (string.startsWith("shell32Icon ") || string.startsWith("shell32LargeIcon ")) {
            String string3 = string.substring(string.indexOf(" ") + 1);
            try {
                int n = Integer.parseInt(string3);
                if (n >= 0) {
                    return Win32ShellFolder2.getShell32Icon(n, string.startsWith("shell32LargeIcon "));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static File checkFile(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        return securityManager == null || file == null ? file : Win32ShellFolderManager2.checkFile(file, securityManager);
    }

    private static File checkFile(File file, SecurityManager securityManager) {
        try {
            Win32ShellFolder2 win32ShellFolder2;
            Win32ShellFolder2 win32ShellFolder22;
            securityManager.checkRead(file.getPath());
            if (file instanceof Win32ShellFolder2 && (win32ShellFolder22 = (Win32ShellFolder2)file).isLink() && (win32ShellFolder2 = (Win32ShellFolder2)win32ShellFolder22.getLinkLocation()) != null) {
                securityManager.checkRead(win32ShellFolder2.getPath());
            }
            return file;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static File[] checkFiles(File[] fileArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || fileArray == null || fileArray.length == 0) {
            return fileArray;
        }
        return Win32ShellFolderManager2.checkFiles(Arrays.stream(fileArray), securityManager);
    }

    private static File[] checkFiles(List<File> list) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || list.isEmpty()) {
            return list.toArray(new File[list.size()]);
        }
        return Win32ShellFolderManager2.checkFiles(list.stream(), securityManager);
    }

    private static File[] checkFiles(Stream<File> stream, SecurityManager securityManager) {
        return (File[])stream.filter(file -> Win32ShellFolderManager2.checkFile(file, securityManager) != null).toArray(File[]::new);
    }

    @Override
    public boolean isComputerNode(final File file) {
        if (file != null && file == Win32ShellFolderManager2.getDrives()) {
            return true;
        }
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return file.getAbsolutePath();
            }
        });
        return string.startsWith("\\\\") && string.indexOf("\\", 2) < 0;
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        if (file != null) {
            Object object;
            Win32ShellFolder2 win32ShellFolder2 = Win32ShellFolderManager2.getDrives();
            if (file instanceof Win32ShellFolder2) {
                object = (Win32ShellFolder2)file;
                if (((Win32ShellFolder2)object).isFileSystem()) {
                    if (((Win32ShellFolder2)object).parent != null) {
                        return ((Win32ShellFolder2)object).parent.equals(win32ShellFolder2);
                    }
                } else {
                    return false;
                }
            }
            if (((String)(object = file.getPath())).length() != 3 || ((String)object).charAt(1) != ':') {
                return false;
            }
            File[] fileArray = win32ShellFolder2.listFiles();
            return fileArray != null && Arrays.asList(fileArray).contains(file);
        }
        return false;
    }

    static int compareShellFolders(Win32ShellFolder2 win32ShellFolder2, Win32ShellFolder2 win32ShellFolder22) {
        boolean bl = win32ShellFolder2.isSpecial();
        boolean bl2 = win32ShellFolder22.isSpecial();
        if (bl && bl2) {
            if (topFolderList == null) {
                ArrayList<Win32ShellFolder2> arrayList = new ArrayList<Win32ShellFolder2>();
                arrayList.add(Win32ShellFolderManager2.getPersonal());
                arrayList.add(Win32ShellFolderManager2.getDesktop());
                arrayList.add(Win32ShellFolderManager2.getDrives());
                arrayList.add(Win32ShellFolderManager2.getNetwork());
                topFolderList = arrayList;
            }
            int n = topFolderList.indexOf(win32ShellFolder2);
            int n2 = topFolderList.indexOf(win32ShellFolder22);
            if (n >= 0 && n2 >= 0) {
                return n - n2;
            }
            if (n >= 0) {
                return -1;
            }
            if (n2 >= 0) {
                return 1;
            }
        }
        if (bl && !bl2) {
            return -1;
        }
        if (bl2 && !bl) {
            return 1;
        }
        return Win32ShellFolderManager2.compareNames(win32ShellFolder2.getAbsolutePath(), win32ShellFolder22.getAbsolutePath());
    }

    static int compareNames(String string, String string2) {
        int n = string.compareToIgnoreCase(string2);
        if (n != 0) {
            return n;
        }
        return string.compareTo(string2);
    }

    @Override
    protected ShellFolder.Invoker createInvoker() {
        return new ComInvoker();
    }

    static native void initializeCom();

    static native void uninitializeCom();

    static {
        WToolkit.loadLibraries();
        STANDARD_VIEW_BUTTONS = new Image[12];
        topFolderList = null;
    }

    private static class ComInvoker
    extends ThreadPoolExecutor
    implements ThreadFactory,
    ShellFolder.Invoker {
        private static Thread comThread;

        private ComInvoker() {
            super(1, 1, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>());
            this.allowCoreThreadTimeOut(false);
            this.setThreadFactory(this);
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            this.shutdownNow();
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(new Thread(runnable));
                    return null;
                }
            });
        }

        @Override
        public synchronized Thread newThread(final Runnable runnable) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        Win32ShellFolderManager2.initializeCom();
                        runnable.run();
                    }
                    finally {
                        Win32ShellFolderManager2.uninitializeCom();
                    }
                }
            };
            comThread = AccessController.doPrivileged(() -> {
                ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
                Thread thread = new Thread(threadGroup, runnable2, "Swing-Shell");
                thread.setDaemon(true);
                return thread;
            });
            return comThread;
        }

        @Override
        public <T> T invoke(Callable<T> callable) throws Exception {
            Future<T> future;
            if (Thread.currentThread() == comThread) {
                return callable.call();
            }
            try {
                future = this.submit(callable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw new InterruptedException(rejectedExecutionException.getMessage());
            }
            try {
                return future.get();
            }
            catch (InterruptedException interruptedException) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        future.cancel(true);
                        return null;
                    }
                });
                throw interruptedException;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException("Unexpected error", throwable);
            }
        }
    }
}

