/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.rmo;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.module.xdts.common.XdtsWordUtil;
import jp.co.extreme.module.xdts.dao.XdtsWordDAO;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.module.xdts.server.XdtsTempProc;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XdtsWordRMO
extends RmiAbstractRMO {
    public void importCsv(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String filePath = rmoArg.getRequest().getDataAsString();
        boolean dataClear = rmoArg.getRequest().getDataAsBoolean();
        this.getLogger().info("importCsv:profileId=" + profileId + " filePath=" + filePath + " dataClear=" + dataClear);
        File file = new File(filePath);
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profileId);
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactoryWk1.wordManager;
        if (dataClear) {
            wordManager.wordMap.clear();
            dtsSessionFactoryWk1.mmdFieldMap.clear();
            XdtsWordDAO.getInstance().deleteByProfileId(dtsSessionMain, profileId);
            this.getLogger().info("Words deleted.");
        }
        XdtsWordUtil.loadWordCsv(wordManager.wordMap, dtsSessionFactoryWk1.mmdFieldMap, file);
        XdtsTempProc tempProc = new XdtsTempProc();
        List<EtcWord> etcWordList = tempProc.toEtcWordList(wordManager.wordMap, dtsSessionFactoryWk1.mmdFieldMap, profileId);
        this.getLogger().debug("etcWordList.size()=" + etcWordList.size());
        this.getLogger().info("Putting words...");
        XdtsWordDAO.getInstance().putEntityCollection(dtsSessionMain, etcWordList);
        dtsSessionMain.commit();
        BcResult result = new BcResult();
        result.addInfo(String.format(BcWords.getInstance().$_items_imported, etcWordList.size()));
        rmoArg.getRespons().addData(result);
    }

    public void exportCsv(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        String filePath = rmoArg.getRequest().getDataAsString();
        this.getLogger().info("profileId=" + profileId + " filePath=" + filePath);
        DtsSession dtsSessionMain = rmoArg.getDtsSession(this);
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profileId);
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactoryWk1.wordManager;
        File destFile = new File(filePath);
        BcTableModel tableModel = XdtsWordUtil.createTable(wordManager.wordMap, dtsSessionFactoryWk1.mmdFieldMap);
        XdtsTempProc tempProc = new XdtsTempProc();
        tempProc.createCsvFile(tableModel, destFile);
        BcResult result = new BcResult();
        result.addInfo(String.format(BcWords.getInstance().$_items_exported, tableModel.getRowCount()));
        rmoArg.getRespons().addData(result);
    }

    public void getWordList(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List<EtcWord> wordList = XdtsWordDAO.getInstance().getListByProfileId(dtsSession, profileId);
        rmoArg.getRespons().addData(wordList);
    }

    public void putWordCollection(RmiRmoArgument rmoArg) throws Exception {
        int profileId = rmoArg.getRequest().getDataAsInteger();
        Collection wordCollection = (Collection)rmoArg.getRequest().getData();
        Collection filedCollection = (Collection)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int cnt = XdtsWordDAO.getInstance().deleteByProfileId(dtsSession, profileId);
        BcLogUtil.debug("\u65e2\u5b58\u30c7\u30fc\u30bf\u524a\u9664\u6570=" + cnt);
        XdtsWordDAO.getInstance().putEntityCollection(dtsSession, wordCollection);
        BcLogUtil.debug("\u6c38\u7d9a\u5316\u6570=" + wordCollection.size());
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, profileId);
        DtsWordManager wordManager = dtsSessionFactoryWk1.wordManager;
        EtcWordUtil.setWordCollection(wordManager, wordCollection);
        Map<String, Map<String, MmdField>> mmdFieldMap = dtsSessionFactoryWk1.mmdFieldMap;
        for (MmdField mmdField : filedCollection) {
            mmdField.tableColumnName = mmdField.tableColumnName.toLowerCase();
            HashMap<String, MmdField> mmdFieldMap2 = new HashMap<String, MmdField>();
            mmdFieldMap2.put("cccccccccccccccC", mmdField);
            mmdFieldMap.put(mmdField.tableColumnName, mmdFieldMap2);
        }
    }

    public static enum Method implements RmiRemoteMethod
    {
        importCsv,
        exportCsv,
        getWordList,
        putWordCollection;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

