/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.fx.tree.FxTreeView;
import jp.co.extreme.module.xdts.fx.XdtsProfileRootTreeHelper;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreePane;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.context.SqlContextFactory;

class XdtsProfileTreeView
extends FxTreeView {
    XdtsProfile profile;
    DtsWordManager wordManager;
    XdtsProfileRootTreeHelper rootTreeHelper = new XdtsProfileRootTreeHelper();
    XdtsProfileTreePane parentPane;

    public XdtsProfileTreeView(XdtsProfileTreePane parentPane) throws Exception {
        this.parentPane = parentPane;
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.rootTreeHelper.setup(this);
        this.setEditable(false);
        this.setShowRoot(true);
        this.getRoot().setExpanded(true);
    }

    protected void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemExpanded(ev);
        this.rootTreeHelper.treeItemExpanded(ev);
    }

    protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemCollapsed(ev);
        this.rootTreeHelper.treeItemCollapsed(ev);
    }

    public void setProfile(XdtsProfile profile, DtsWordManager wordManager) throws Exception {
        this.profile = profile;
        this.wordManager = wordManager;
        SqlContext sqlContext = SqlContextFactory.getSqlContext(profile.productId);
        this.rootTreeHelper.setProfile(profile, sqlContext, wordManager, this);
        this.rootTreeHelper.refresh();
    }

    protected void destruct() throws Exception {
        this.rootTreeHelper.destruct();
    }
}

