/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.mmdx.model.MmdxIndexField;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class MmdxIndexFieldDAO
extends OrmAbstractDAO<MmdxIndexField> {
    public static final int MODE_default = 1;

    private MmdxIndexFieldDAO() {
        super(new MmdxIndexField[0]);
        this.setTableName("mdx_index_field");
    }

    public static MmdxIndexFieldDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, Integer schemaId, String indexName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(indexName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("index_name " + sqlContext.toCondition_string("=", indexName));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + BcStringUtil.appendCaseOfTestDataNotEmpty(alias, " AS " + alias));
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "schema_id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "index_name");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "order_number");
        }
        return selectQuery;
    }

    public List<MmdxIndexField> getList(DtsSession dtsSession, Integer schemaId, String indexName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = null;
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, schemaId, indexName);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public long deleteByIndexName(DtsSession dtsSession, Integer schemaId, String indexName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE FROM " + this.getTableName() + " WHERE schema_id = " + schemaId + " AND index_name" + sqlContext.toCondition_string("=", indexName);
        BcLogUtil.debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ MmdxIndexFieldDAO(MmdxIndexFieldDAO mmdxIndexFieldDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final MmdxIndexFieldDAO instance = new MmdxIndexFieldDAO(null);

        private SingletonHolder() {
        }
    }
}

