/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.FancyButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.CodeSigner;
import java.security.Timestamp;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RuleSetViewerDialog
extends JDialog {
    public static final int LOCATION_WIDTH = 500;
    public static final Dimension DRS_PANE_PREFERRED_SIZE = new Dimension(600, 340);
    private Font boldFont;
    private CodeSigner signer;
    final JLabel validation1 = new JLabel();
    final JLabel validation2 = new JLabel();
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";

    RuleSetViewerDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.validateDRS();
        }
        super.setVisible(bl);
    }

    private void initComponents() {
        this.signer = this.getCodeSigner();
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(2);
        this.setTitle(RuleSetViewerDialog.getMessage("deployment.ruleset.view.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RuleSetViewerDialog.this.closeDialog();
            }
        });
        jPanel.add((Component)this.createLocationPanel(), "North");
        jPanel.add((Component)this.createRuleSetPanel(), "Center");
        jPanel.add((Component)this.createBottomPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private JComponent createLocationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(RuleSetViewerDialog.getMessage("deployment.ruleset.view.location"));
        this.setBoldFont(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
        jPanel.add((Component)jLabel, "West");
        String string = this.getSecurityLocation();
        if (string == null) {
            string = RuleSetViewerDialog.getMessage("deployment.ruleset.view.error.location");
        }
        JLabel jLabel2 = new JLabel(this.limitSize(this.getSecurityLocation()));
        jLabel2.setToolTipText(string);
        jLabel2.setPreferredSize(new Dimension(500, jLabel2.getPreferredSize().height));
        jPanel.add((Component)jLabel2, "Center");
        return jPanel;
    }

    private String limitSize(String string) {
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        StringTruncator stringTruncator = new StringTruncator(fontMetrics);
        return stringTruncator.truncate(string, 500);
    }

    private JComponent createRuleSetPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea(this.getDRSText());
        jTextArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jTextArea.setLineWrap(false);
        jTextArea.setWrapStyleWord(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(DRS_PANE_PREFERRED_SIZE);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private String getDRSText() {
        String string = RuleSetViewerDialog.getMessage("deployment.ruleset.view.error.ruleset.not.found");
        File file = Config.getDRSFile();
        if (file != null && file.exists()) {
            try {
                JarFile jarFile = new JarFile(file, false);
                JarEntry jarEntry = jarFile.getJarEntry("ruleset.xml");
                if (jarEntry != null) {
                    String string2;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2);
                        stringBuilder.append("\n");
                    }
                    return stringBuilder.toString();
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
                string = exception.getMessage();
            }
        }
        return string;
    }

    private JComponent createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(RuleSetViewerDialog.getMessage("deployment.ruleset.view.timestamp"));
        this.setBoldFont(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        JLabel jLabel2 = new JLabel(this.getRuleSetTimestamp());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jLabel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        jPanel3.add((Component)jPanel2, "North");
        this.validation1.setText(RuleSetViewerDialog.getMessage("ruleset.view.validating"));
        this.validation2.setText("");
        jPanel3.add((Component)this.validation1, "Center");
        jPanel3.add((Component)this.validation2, "South");
        jPanel.add((Component)jPanel3, "North");
        FancyButton fancyButton = new FancyButton(ResourceManager.getMessage("sandbox.security.more.info.details"), ResourceManager.getMnemonic("sandbox.security.more.info.details"), Color.BLUE);
        fancyButton.setVisible(this.signer != null);
        fancyButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof FancyButton) {
                    RuleSetViewerDialog.this.showCertDetails();
                }
            }
        });
        fancyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof FancyButton) {
                    RuleSetViewerDialog.this.showCertDetails();
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(RuleSetViewerDialog.getMessage("cert.dialog.close"));
        jButton.setMnemonic(RuleSetViewerDialog.getAcceleratorKey("cert.dialog.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RuleSetViewerDialog.this.closeDialog();
            }
        });
        jPanel4.add(jButton);
        Box box = Box.createVerticalBox();
        box.add(fancyButton);
        box.add(jPanel4);
        jPanel.add((Component)box, "East");
        return jPanel;
    }

    private void showCertDetails() {
        if (this.signer != null) {
            List<? extends Certificate> list = this.signer.getSignerCertPath().getCertificates();
            Certificate[] certificateArray = list.toArray(new Certificate[0]);
            CertificateDialog.showCertificates(this, certificateArray, 0, certificateArray.length);
        }
    }

    private CodeSigner getCodeSigner() {
        File file = Config.getDRSFile();
        if (file != null && file.exists() && Config.isJavaVersionAtLeast16()) {
            try {
                Object[] objectArray;
                JarFile jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry("ruleset.xml");
                if (jarEntry == null) {
                    return null;
                }
                InputStream inputStream = null;
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    objectArray = new byte[1024];
                    int n = objectArray.length;
                    while (n != -1) {
                        n = inputStream.read((byte[])objectArray, 0, objectArray.length);
                    }
                    inputStream.close();
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                    return null;
                }
                objectArray = jarEntry.getCodeSigners();
                if (objectArray != null && objectArray.length != 0) {
                    return objectArray[0];
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        return null;
    }

    private String getRuleSetTimestamp() {
        Timestamp timestamp;
        if (this.signer != null && (timestamp = this.signer.getTimestamp()) != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            return simpleDateFormat.format(timestamp.getTimestamp());
        }
        return RuleSetViewerDialog.getMessage("deployment.ruleset.view.error.timestamp");
    }

    private String getSecurityLocation() {
        File file = Config.getDRSFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return RuleSetViewerDialog.getMessage("deployment.ruleset.view.error.location");
    }

    private void setBoldFont(JLabel jLabel) {
        if (this.boldFont == null) {
            Font font = jLabel.getFont();
            this.boldFont = new Font(font.getName(), 1, font.getSize());
        }
        jLabel.setFont(this.boldFont);
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    private void validateDRS() {
        new Thread(new Runnable(){

            public void run() {
                File file = Config.getDRSFile();
                String string = null;
                try {
                    DeploymentRuleSet.validateDRS(file);
                    Trace.println("DRS jar validated");
                }
                catch (Exception exception) {
                    Trace.println("Exception verifying DRS: " + exception);
                    string = exception.getMessage();
                }
                final String string2 = string == null ? RuleSetViewerDialog.getMessage("ruleset.view.valid") : RuleSetViewerDialog.getMessage("ruleset.view.invalid");
                final String string3 = string == null ? "" : string;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RuleSetViewerDialog.this.validation1.setText(string2);
                        RuleSetViewerDialog.this.validation2.setText(string3);
                    }
                });
            }
        }).start();
    }

    private class StringTruncator {
        private static final String ELLIPSIS = "...";
        private List paths;
        private FontMetrics fontMetrics;

        StringTruncator(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
        }

        public String truncate(String string, int n) {
            this.paths = new ArrayList<String>(Arrays.asList(string.split(Pattern.quote(File.separator))));
            String string2 = string;
            while (this.fontMetrics.stringWidth(string2) >= n) {
                if (!this.removeMiddleElement()) {
                    return string;
                }
                string2 = this.reconstructPath();
            }
            return this.reconstructPath();
        }

        private boolean removeMiddleElement() {
            if (this.paths.size() <= 2) {
                return false;
            }
            int n = this.paths.size();
            int n2 = n / 2;
            if (this.paths.get(n2).equals(ELLIPSIS)) {
                this.paths.remove(n2 - 1);
            } else {
                this.paths.remove(n2);
            }
            String string = this.reconstructPath();
            if (!string.contains(ELLIPSIS)) {
                this.paths.add(n2, ELLIPSIS);
            }
            return true;
        }

        private String reconstructPath() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.paths.size(); ++i) {
                stringBuilder.append(this.paths.get(i));
                if (i + 1 >= this.paths.size()) continue;
                stringBuilder.append(File.separator);
            }
            return stringBuilder.toString();
        }
    }
}

