/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.extreme.activation.BcMimeUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.css.common.CssUtil;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlDataAttribute;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlImageAttribute;
import jp.co.extreme.html.common.HtmlTagAttribute;
import jp.co.extreme.html.util.HtmlUtil;

public class HtmlBuilder
extends BcLoggableObject {
    public String lineSep = "\n";
    protected boolean lineSepEnabled = true;
    public static final int HTML32 = 1;
    public static final int HTML40_FRAMESET = 2;
    public static final String on = "on";
    public static final String off = "off";

    public static HtmlBuilder getInstance() {
        return SingletonHolder.instance;
    }

    public boolean isLineSepEnabled() {
        return this.lineSepEnabled;
    }

    public void setLineSepEnabled(boolean lineSepEnabled) {
        this.lineSepEnabled = lineSepEnabled;
    }

    public String appLineSep() {
        if (this.lineSepEnabled) {
            return this.lineSep;
        }
        return "";
    }

    public String toAttributeText(String name, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (!BcStringUtil.isEmpty(value)) {
            sb.append("=");
            String valueString = BcStringUtil.toString(value);
            sb.append(BcStringUtil.doubleQuotation(valueString));
        }
        return sb.toString();
    }

    public String toAttributeText(HtmlTagAttribute tagAttribute) {
        String strValue = BcStringUtil.toString(tagAttribute.getValue());
        return this.toAttributeText((String)tagAttribute.getKey(), strValue);
    }

    public String toAttributeText(HtmlTagAttribute ... tagAttributes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tagAttributes.length) {
            HtmlTagAttribute tagAttribute = tagAttributes[i];
            String attrib = this.toAttributeText(tagAttribute);
            if (!BcStringUtil.isEmpty(attrib)) {
                BcStringUtil.appendCaseOfTestDataNotEmpty(sb, sb, Character.valueOf(' '));
                sb.append(attrib);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toAttributeText(Collection<? extends HtmlTagAttribute> tagAttributeCollection) {
        HtmlTagAttribute[] tagAttributes = tagAttributeCollection.toArray(new HtmlTagAttribute[tagAttributeCollection.size()]);
        return this.toAttributeText(tagAttributes);
    }

    public List<HtmlTagAttribute> toAttributeList(HtmlGlobalAttribute globalAttribute) {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        if (globalAttribute == null) {
            return tagAttributeList;
        }
        if (!BcStringUtil.isEmpty(globalAttribute.clazz)) {
            tagAttributeList.add(new HtmlTagAttribute("class", globalAttribute.clazz));
        }
        if (!BcStringUtil.isEmpty(globalAttribute.style)) {
            tagAttributeList.add(new HtmlTagAttribute("style", globalAttribute.style));
        }
        if (!BcStringUtil.isEmpty(globalAttribute.id)) {
            tagAttributeList.add(new HtmlTagAttribute("id", globalAttribute.id));
        }
        if (!BcStringUtil.isEmpty(globalAttribute.title)) {
            tagAttributeList.add(new HtmlTagAttribute("title", globalAttribute.title));
        }
        if (!BcStringUtil.isEmpty(globalAttribute.lang)) {
            tagAttributeList.add(new HtmlTagAttribute("lang", globalAttribute.lang));
        }
        if (!BcStringUtil.isEmpty(globalAttribute.dir)) {
            tagAttributeList.add(new HtmlTagAttribute("dir", globalAttribute.dir));
        }
        if (!BcCollectionUtil.isEmpty(globalAttribute.dataAttributeCollection)) {
            for (HtmlDataAttribute dataAttribute : globalAttribute.dataAttributeCollection) {
                tagAttributeList.add(new HtmlTagAttribute("data-" + dataAttribute.name, dataAttribute.toValueString()));
            }
        }
        return tagAttributeList;
    }

    public String toGlobalAttributes(HtmlGlobalAttribute globalAttribute) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        return this.toAttributeText(tagAttributeList);
    }

    public List<HtmlTagAttribute> toAttributeList(String id, String clazz, String style, String title, String lang, String dir) {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = id;
        globalAttribute.clazz = clazz;
        globalAttribute.style = style;
        globalAttribute.title = title;
        globalAttribute.lang = lang;
        globalAttribute.dir = dir;
        return this.toAttributeList(globalAttribute);
    }

    public HtmlGlobalAttribute toGlobalAttribute(String id, String clazz, String style, String title, String lang, String dir) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = id;
        globalAttribute.clazz = clazz;
        globalAttribute.style = style;
        globalAttribute.title = title;
        globalAttribute.lang = lang;
        globalAttribute.dir = dir;
        return globalAttribute;
    }

    public String globalAttributes(String id, String clazz, String style, String title, String lang, String dir) throws Exception {
        HtmlGlobalAttribute globalAttribute = this.toGlobalAttribute(id, clazz, style, title, lang, dir);
        return this.toGlobalAttributes(globalAttribute);
    }

    public String globalAttributes(String id, String clazz, String style, String title, String lang) throws Exception {
        return this.globalAttributes(id, clazz, style, title, lang, null);
    }

    public String globalAttributes(String id, String clazz, String style) throws Exception {
        return this.globalAttributes(id, clazz, style, null, null);
    }

    public String globalAttributes(String id, String clazz) throws Exception {
        return this.globalAttributes(id, clazz, null);
    }

    public String tagStart(String tagName, String attribute, boolean lineFeed) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(tagName);
        if (!BcStringUtil.isEmpty(attribute)) {
            sb.append(" ");
            sb.append(attribute);
        }
        sb.append(">");
        if (lineFeed) {
            sb.append(this.appLineSep());
        }
        return sb.toString();
    }

    public String tagStart(String tagName, Collection<? extends HtmlTagAttribute> tagAttributeCollection, boolean lineFeed) {
        String attribute = null;
        if (!BcCollectionUtil.isEmpty(tagAttributeCollection)) {
            attribute = this.toAttributeText(tagAttributeCollection);
        }
        return this.tagStart(tagName, attribute, lineFeed);
    }

    public String tagStart(HtmlConstants.HtmlTag tag, Collection<? extends HtmlTagAttribute> tagAttributeCollection, boolean lineFeed) {
        return this.tagStart(tag.name(), tagAttributeCollection, lineFeed);
    }

    public String tagStart(String tagName, boolean lineFeed, HtmlTagAttribute ... tagAttributes) throws Exception {
        String tagAttributesText = this.toAttributeText(tagAttributes);
        return this.tagStart(tagName, tagAttributesText, lineFeed);
    }

    public String tagStart(String tagName, HtmlGlobalAttribute globalAttribute, boolean lineFeed) {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        return this.tagStart(tagName, tagAttributeList, lineFeed);
    }

    public String tagStart(HtmlConstants.HtmlTag tag, HtmlGlobalAttribute globalAttribute, boolean lineFeed) {
        return this.tagStart(tag.name(), globalAttribute, lineFeed);
    }

    public String tagStart(HtmlConstants.HtmlTag tag, HtmlGlobalAttribute globalAttribute) {
        return this.tagStart(tag.name(), globalAttribute, false);
    }

    public String tagStart(String tagName, boolean lineFeed) {
        HtmlGlobalAttribute globalAttribute = null;
        return this.tagStart(tagName, globalAttribute, lineFeed);
    }

    public String tagStart(HtmlConstants.HtmlTag tag, boolean lineFeed) {
        return this.tagStart(tag.name(), lineFeed);
    }

    public String tagEnd(String tagName, boolean lineFeed) {
        StringBuilder sb = new StringBuilder();
        sb.append("</");
        sb.append(tagName);
        sb.append(">");
        if (lineFeed) {
            sb.append(this.appLineSep());
        }
        return sb.toString();
    }

    public String tagEnd(HtmlConstants.HtmlTag tag, boolean lineFeed) {
        return this.tagEnd(tag.name(), lineFeed);
    }

    public String html_start(boolean lineFeed) {
        return this.tagStart(HtmlConstants.HtmlTag.html, lineFeed);
    }

    public String html_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.html, true);
    }

    public String html(String content, boolean lineFeed) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.html_start(lineFeed));
        BcStringUtil.append(sb, content);
        sb.append(this.html_end());
        return sb.toString();
    }

    public String div_start(Collection<HtmlTagAttribute> tagAttributeCollection, boolean lineFeed) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.div, tagAttributeCollection, lineFeed);
    }

    public String div_start(HtmlGlobalAttribute globalAttribute, boolean lineFeed) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.div, globalAttribute, lineFeed);
    }

    public String div_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.div_start(globalAttribute, false);
    }

    public String div_start(String clazz, boolean lineFeed) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.div_start(globalAttribute, lineFeed);
    }

    public String div_start(boolean lineFeed, Collection classNameCollection) throws Exception {
        return this.div_start(BcStringUtil.toSsv(classNameCollection), lineFeed);
    }

    public String div_start(Collection classNameCollection) throws Exception {
        return this.div_start(true, classNameCollection);
    }

    public String div_start(boolean lineFeed, Object ... classNames) throws Exception {
        return this.div_start(lineFeed, Arrays.asList(classNames));
    }

    public String div_start(String ... classNames) throws Exception {
        return this.div_start(true, (Object[])classNames);
    }

    public String div_start() throws Exception {
        HtmlGlobalAttribute globalAttribute = null;
        return this.div_start(globalAttribute);
    }

    public String div_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.div, true);
    }

    public StringBuilder div(HtmlGlobalAttribute globalAttribute) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.div_start(globalAttribute, false));
        sb.append(this.div_end());
        return sb;
    }

    public StringBuilder div(Object ... classNames) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.div_start(false, classNames));
        sb.append(this.div_end());
        return sb;
    }

    public StringBuilder div(String content, HtmlConstants.HtmlAlign align, int marginPx) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        if (marginPx > 0) {
            globalAttribute.style = CssUtil.createProperty("margin", (Object)(String.valueOf(marginPx) + "px"));
        }
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (align != null) {
            tagAttributeList.add(new HtmlTagAttribute(HtmlConstants.DivAttribute.align.name(), align.name()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.div_start(tagAttributeList, true));
        BcStringUtil.append(sb, content);
        sb.append(this.div_end());
        return sb;
    }

    public String form_start(HtmlGlobalAttribute globalAttribute, String name, String action, String method, String enctype, String target, boolean autocomplete) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(name)) {
            tagAttributeList.add(new HtmlTagAttribute("name", name));
        }
        if (!BcStringUtil.isEmpty(action)) {
            tagAttributeList.add(new HtmlTagAttribute("action", action));
        }
        if (!BcStringUtil.isEmpty(method)) {
            tagAttributeList.add(new HtmlTagAttribute("method", method));
        }
        if (BcStringUtil.isEmpty(enctype)) {
            if ("post".equalsIgnoreCase(method)) {
                tagAttributeList.add(new HtmlTagAttribute("enctype", BcStringUtil.doubleQuotation("application/x-www-form-url-encoded")));
            }
        } else {
            tagAttributeList.add(new HtmlTagAttribute("enctype", enctype));
        }
        if (!BcStringUtil.isEmpty(target)) {
            tagAttributeList.add(new HtmlTagAttribute("target", target));
        }
        if (autocomplete) {
            tagAttributeList.add(new HtmlTagAttribute("autocomplete", HtmlBuilder.toOnOf\uff46(autocomplete)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.form.name(), tagAttributeList, true));
        return sb.toString();
    }

    public String form_start(String name, String action, String method, String enctype) throws Exception {
        return this.form_start(null, name, action, method, enctype, null, false);
    }

    public String form_start(String name, String method, String enctype) throws Exception {
        return this.form_start(name, null, method, enctype);
    }

    public String form_start(String name, String method) throws Exception {
        return this.form_start(name, method, null);
    }

    public String form_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.form, true);
    }

    public String label_start(HtmlGlobalAttribute globalAttribute, String for_) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(for_)) {
            tagAttributeList.add(new HtmlTagAttribute("for", for_));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.label.name(), tagAttributeList, false));
        return sb.toString();
    }

    public String label_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.label, true);
    }

    public StringBuilder span_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.span.name(), tagAttributeList, false));
        return sb;
    }

    public String span_end(boolean lineFeed) {
        return this.tagEnd(HtmlConstants.HtmlTag.span, lineFeed);
    }

    public String span_end() {
        return this.span_end(false);
    }

    public String span(HtmlGlobalAttribute globalAttribute, String content) throws Exception {
        StringBuilder sb = this.span_start(globalAttribute);
        if (!BcStringUtil.isEmpty(content)) {
            sb.append(HtmlUtil.encode(content));
        }
        sb.append(this.span_end());
        return sb.toString();
    }

    public String span(String content) throws Exception {
        return this.span(null, content);
    }

    public List<HtmlTagAttribute> toInputAttributeList(String type, String name, Object value, int size, int maxLength, boolean disabled, boolean readonly, boolean multiple, String pattern, String placeholder, String list, String autocomplete) throws Exception {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        tagAttributeList.add(new HtmlTagAttribute("type", type));
        if (!BcStringUtil.isEmpty(name)) {
            tagAttributeList.add(new HtmlTagAttribute("name", name));
        }
        if (value != null) {
            String strValue = BcStringUtil.toString(value);
            tagAttributeList.add(new HtmlTagAttribute("value", HtmlUtil.encode(strValue)));
        }
        if (size > 0) {
            tagAttributeList.add(new HtmlTagAttribute("size", (Object)size));
        }
        if (maxLength > 0) {
            tagAttributeList.add(new HtmlTagAttribute("maxlength", (Object)maxLength));
        }
        if (disabled) {
            tagAttributeList.add(new HtmlTagAttribute("disabled", (Object)null));
        }
        if (readonly) {
            tagAttributeList.add(new HtmlTagAttribute("readonly", (Object)null));
        }
        if (multiple) {
            tagAttributeList.add(new HtmlTagAttribute("multiple", (Object)null));
        }
        if (!BcStringUtil.isEmpty(pattern)) {
            tagAttributeList.add(new HtmlTagAttribute("pattern", pattern));
        }
        if (!BcStringUtil.isEmpty(placeholder)) {
            tagAttributeList.add(new HtmlTagAttribute("placeholder", placeholder));
        }
        if (!BcStringUtil.isEmpty(list)) {
            tagAttributeList.add(new HtmlTagAttribute("list", list));
        }
        if (!BcStringUtil.isEmpty(autocomplete)) {
            tagAttributeList.add(new HtmlTagAttribute("autocomplete", autocomplete));
        }
        return tagAttributeList;
    }

    public List<HtmlTagAttribute> toInputAttributeList(String type, String name, Object value, boolean disabled) throws Exception {
        int size = -1;
        int maxLength = -1;
        boolean readonly = false;
        boolean multiple = false;
        String pattern = null;
        String placeholder = null;
        String list = null;
        String autocomplete = null;
        return this.toInputAttributeList(type, name, value, size, maxLength, disabled, readonly, multiple, pattern, placeholder, list, autocomplete);
    }

    public String input(Collection<? extends HtmlTagAttribute> tagAttributeCollection, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<input ");
        sb.append(this.toAttributeText(tagAttributeCollection));
        if (!BcStringUtil.isEmpty(script)) {
            BcStringUtil.appendCaseOfTestDataNotEmpty(sb, sb, Character.valueOf(' '));
            sb.append(script);
        }
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String input(HtmlGlobalAttribute globalAttribute, HtmlConstants.HtmlInputType inputType, String name, Object value, int size, int maxLength, boolean disabled, boolean readonly, boolean multiple, String pattern, String placeholder, String list, String autocomplete, String script) throws Exception {
        List<HtmlTagAttribute> tagAttributeList1 = this.toAttributeList(globalAttribute);
        List<HtmlTagAttribute> tagAttributeList2 = this.toInputAttributeList(inputType.value, name, value, size, maxLength, disabled, readonly, multiple, pattern, placeholder, list, autocomplete);
        tagAttributeList1.addAll(tagAttributeList2);
        return this.input(tagAttributeList1, script);
    }

    public String input(HtmlConstants.HtmlInputType inputType, String name, Object value, int size, int maxLength, boolean disabled, boolean multiple, String clazz, String pattern, String autocomplete, String script) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        boolean readonly = false;
        String placeholder = null;
        String list = null;
        return this.input(globalAttribute, inputType, name, value, size, maxLength, disabled, readonly, multiple, pattern, placeholder, list, autocomplete, script);
    }

    public String input(HtmlConstants.HtmlInputType inputType, String name, Object value, int size, int maxLength, boolean disabled, boolean multiple, String clazz, String pattern, String script) throws Exception {
        String autocomplete = null;
        return this.input(inputType, name, value, size, maxLength, disabled, multiple, clazz, pattern, autocomplete, script);
    }

    public String hidden(String name, Object value, String id) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = id;
        List<HtmlTagAttribute> tagAttributeList1 = this.toAttributeList(globalAttribute);
        boolean disabled = false;
        List<HtmlTagAttribute> tagAttributeList2 = this.toInputAttributeList(HtmlConstants.HtmlInputType.hidden.value, name, value, disabled);
        tagAttributeList1.addAll(tagAttributeList2);
        return this.input(tagAttributeList1, null);
    }

    public String hidden(String name, Object value) throws Exception {
        String id = null;
        return this.hidden(name, value, id);
    }

    public String textField(String name, Object value, int size, int maxLength, boolean disabled, String clazz, String script) throws Exception {
        boolean multiple = false;
        String pattern = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this.input(HtmlConstants.HtmlInputType.text, name, value, size, maxLength, disabled, multiple, clazz, pattern, script));
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String textField(String name, Object value, int size, int maxLength, String clazz, String script) throws Exception {
        return this.textField(name, value, size, maxLength, false, clazz, script);
    }

    public String textField(String name, Object value, int size, int maxLength) throws Exception {
        return this.textField(name, value, size, maxLength, null, null);
    }

    public String textField(String name, Object value) throws Exception {
        return this.textField(name, value, -1, -1);
    }

    public String inputButton(HtmlGlobalAttribute globalAttribute, HtmlConstants.HtmlInputType inputType, String name, Object value, boolean disabled, String script) throws Exception {
        List<HtmlTagAttribute> tagAttributeList1 = this.toAttributeList(globalAttribute);
        List<HtmlTagAttribute> tagAttributeList2 = this.toInputAttributeList(inputType.value, name, value, disabled);
        tagAttributeList1.addAll(tagAttributeList2);
        return this.input(tagAttributeList1, script);
    }

    public String inputButton(HtmlConstants.HtmlInputType inputType, String name, Object value, boolean disabled, String clazz, String script) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.inputButton(globalAttribute, inputType, name, value, disabled, script);
    }

    public String inputButton(HtmlConstants.HtmlInputType inputType, String name, Object value, String clazz, String script) throws Exception {
        return this.inputButton(inputType, name, value, false, clazz, script);
    }

    public List<HtmlTagAttribute> toTextAreaAttributeList(int cols, int rows) throws Exception {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        if (cols > 0) {
            tagAttributeList.add(new HtmlTagAttribute("cols", (Object)cols));
        }
        if (rows > 0) {
            tagAttributeList.add(new HtmlTagAttribute("rows", (Object)rows));
        }
        return tagAttributeList;
    }

    public String textArea(Collection<? extends HtmlTagAttribute> tagAttributeCollection, String script, String value) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<textarea ");
        sb.append(this.toAttributeText(tagAttributeCollection));
        if (!BcStringUtil.isEmpty(script)) {
            BcStringUtil.appendCaseOfTestDataNotEmpty(sb, sb, Character.valueOf(' '));
            sb.append(script);
        }
        sb.append(">");
        sb.append(this.appLineSep());
        if (!BcStringUtil.isEmpty(value)) {
            sb.append(HtmlUtil.encode(value));
        }
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.textarea, true));
        return sb.toString();
    }

    public String textArea(HtmlGlobalAttribute globalAttribute, String name, String value, int columnCount, int rowCount, boolean disabled, boolean readonly, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<textarea ");
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (disabled) {
            tagAttributeList.add(new HtmlTagAttribute("disabled", (Object)null));
        }
        if (readonly) {
            tagAttributeList.add(new HtmlTagAttribute("readonly", (Object)null));
        }
        sb.append(this.toAttributeText(tagAttributeList));
        if (!BcStringUtil.isEmpty(name)) {
            sb.append(" name=" + BcStringUtil.doubleQuotation(name));
        }
        if (columnCount > 0) {
            sb.append(" cols=" + columnCount);
        }
        if (rowCount > 0) {
            sb.append(" rows=" + rowCount);
        }
        if (!BcStringUtil.isEmpty(script)) {
            sb.append(" " + script);
        }
        sb.append(" type=" + BcStringUtil.doubleQuotation("text"));
        sb.append(">");
        if (!BcStringUtil.isEmpty(value)) {
            sb.append(value);
        }
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.textarea, true));
        return sb.toString();
    }

    public String textArea(HtmlGlobalAttribute globalAttribute, String name, String value, int columnCount, int rowCount, String script) throws Exception {
        return this.textArea(globalAttribute, name, value, columnCount, rowCount, false, false, script);
    }

    public String textArea(HtmlGlobalAttribute globalAttribute, String name, String value, int columnCount, int rowCount) throws Exception {
        return this.textArea(globalAttribute, name, value, columnCount, rowCount, null);
    }

    public String checkBoxAbstract(HtmlGlobalAttribute globalAttribute, String type, String name, Object value, boolean disabled, boolean checked, String script) throws Exception {
        List<HtmlTagAttribute> tagAttributeList1 = this.toAttributeList(globalAttribute);
        List<HtmlTagAttribute> tagAttributeList2 = this.toInputAttributeList(type, name, value, disabled);
        if (checked) {
            tagAttributeList2.add(new HtmlTagAttribute("checked", (Object)null));
        }
        tagAttributeList1.addAll(tagAttributeList2);
        return this.input(tagAttributeList1, script);
    }

    public String checkBox(HtmlGlobalAttribute globalAttribute, String name, Object value, boolean disabled, boolean checked, String script) throws Exception {
        return this.checkBoxAbstract(globalAttribute, HtmlConstants.HtmlInputType.checkbox.value, name, value, disabled, checked, script);
    }

    public String radioButton(HtmlGlobalAttribute globalAttribute, String name, Object value, boolean disabled, boolean checked, String script) throws Exception {
        return this.checkBoxAbstract(globalAttribute, HtmlConstants.HtmlInputType.radio.value, name, value, disabled, checked, script);
    }

    public String file(HtmlGlobalAttribute globalAttribute, String name, Object value, int size, boolean disabled, boolean multiple, String script) throws Exception {
        int maxLength = -1;
        boolean readonly = false;
        String pattern = null;
        String placeholder = null;
        String list = null;
        String autocomplete = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this.input(globalAttribute, HtmlConstants.HtmlInputType.file, name, value, size, maxLength, readonly, disabled, multiple, pattern, placeholder, list, autocomplete, script));
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String file(String name, Object value, int size, boolean disabled, boolean multiple, String clazz, String script) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.file(globalAttribute, name, value, size, disabled, multiple, script);
    }

    public String h(HtmlGlobalAttribute globalAttribute, int size, String text) throws Exception {
        StringBuilder sb = new StringBuilder(this.tagStart("h" + size, globalAttribute, false));
        sb.append(HtmlUtil.encode(text));
        sb.append(this.tagEnd("h" + size, true));
        return sb.toString();
    }

    public String h(int size, String text, String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = null;
        if (!BcStringUtil.isEmpty(clazz)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = clazz;
        }
        return this.h(globalAttribute, size, text);
    }

    public String h(int size, String text) throws Exception {
        return this.h(size, text, null);
    }

    public String encode(Object value, boolean doEncode) throws Exception {
        String str = BcStringUtil.toString(value);
        if (doEncode) {
            str = HtmlUtil.encode(str);
        }
        return str;
    }

    public String p(HtmlGlobalAttribute globalAttribute, Object content, boolean doEncode, boolean lineFeed) throws Exception {
        StringBuilder sb = new StringBuilder(this.tagStart(HtmlConstants.HtmlTag.p, globalAttribute, false));
        sb.append(this.encode(content, doEncode));
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.p, lineFeed));
        return sb.toString();
    }

    public String p(Object content, boolean doEncode, boolean lineFeed) throws Exception {
        Object clazz = null;
        return this.p(null, content, doEncode, lineFeed);
    }

    public String p(Object content, boolean doEncode) throws Exception {
        Object clazz = null;
        return this.p(null, content, doEncode, false);
    }

    public String a_start(HtmlGlobalAttribute globalAttribute, String href, String target) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(href)) {
            tagAttributeList.add(new HtmlTagAttribute("href", href));
        }
        if (!BcStringUtil.isEmpty(target)) {
            tagAttributeList.add(new HtmlTagAttribute("target", target));
            if (HtmlConstants.FrameTarget._blank.name().equalsIgnoreCase(target)) {
                tagAttributeList.add(new HtmlTagAttribute("rel", "noopener noreferrer"));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.a.name(), tagAttributeList, false));
        return sb.toString();
    }

    public String a_start(String href, String clazz, String target) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.a_start(globalAttribute, href, target);
    }

    public String a_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.a, false);
    }

    public String a(HtmlGlobalAttribute globalAttribute, String href, String text, String target) throws Exception {
        StringBuilder sb = new StringBuilder(this.a_start(globalAttribute, href, target));
        if (!BcStringUtil.isEmpty(text)) {
            sb.append(HtmlUtil.encode(text));
        }
        sb.append(this.a_end());
        return sb.toString();
    }

    public String a(String href, String text, String clazz, String target) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.a(globalAttribute, href, text, target);
    }

    public String a(String href, String text, String clazz) throws Exception {
        return this.a(href, text, clazz, null);
    }

    public String a(String href, String text) throws Exception {
        return this.a(href, text, null);
    }

    public String select(HtmlGlobalAttribute globalAttribute, String name, Collection<? extends Map.Entry> optionCollection, Object selectedValue, String onChange) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(name)) {
            tagAttributeList.add(new HtmlTagAttribute("name", name));
        }
        if (!BcStringUtil.isEmpty(onChange)) {
            tagAttributeList.add(new HtmlTagAttribute("onchange", onChange));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.select.name(), tagAttributeList, true));
        int selectedIndex = this.getIndex(optionCollection, selectedValue);
        int index = -1;
        for (Map.Entry entry : optionCollection) {
            ++index;
            sb.append("<" + (Object)((Object)HtmlConstants.HtmlTag.option));
            if (!BcStringUtil.isEmpty(entry.getKey())) {
                sb.append(" value=" + BcStringUtil.doubleQuotation(entry.getKey()));
            }
            if (index == selectedIndex) {
                sb.append(" selected");
            }
            sb.append(">");
            if (!BcStringUtil.isEmpty(entry.getValue())) {
                sb.append(HtmlUtil.encode(BcStringUtil.toString(entry.getValue())));
            }
            sb.append(this.tagEnd(HtmlConstants.HtmlTag.option, true));
        }
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.select, true));
        return sb.toString();
    }

    public int getIndex(Collection<? extends Map.Entry> optionCollection, Object value) throws Exception {
        int index = -1;
        for (Map.Entry entry : optionCollection) {
            String str2;
            ++index;
            String str1 = BcStringUtil.toString(entry.getKey());
            if (!BcStringUtil.equals(str1, str2 = BcStringUtil.toString(value))) continue;
            return index;
        }
        return -1;
    }

    public String select(String name, List<? extends Map.Entry<String, String>> optionList, String selectedValue, String script) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        return this.select(globalAttribute, name, optionList, selectedValue, script);
    }

    public String select(String name, List<? extends Map.Entry<String, String>> optionList, String selectedValue) throws Exception {
        return this.select(name, optionList, selectedValue, null);
    }

    public String table_start(HtmlGlobalAttribute globalAttribute, String width, String height, int border, int cellSpacing, int cellPadding, String bgColor) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (globalAttribute != null) {
            String globalAttributes = this.toGlobalAttributes(globalAttribute);
            BcStringUtil.appendCaseOfTestDataNotEmpty(sb, globalAttributes, String.valueOf(BcStringUtil.SPACE_STR) + globalAttributes);
        }
        if (!BcStringUtil.isEmpty(width)) {
            sb.append(" width=" + BcStringUtil.doubleQuotation(width));
        }
        if (!BcStringUtil.isEmpty(height)) {
            sb.append(" height=" + BcStringUtil.doubleQuotation(height));
        }
        if (border >= 0) {
            sb.append(" border=" + BcStringUtil.doubleQuotation(border));
        }
        if (cellSpacing >= 0) {
            sb.append(" cellspacing=" + BcStringUtil.doubleQuotation(cellSpacing));
        }
        if (cellPadding >= 0) {
            sb.append(" cellpadding=" + BcStringUtil.doubleQuotation(cellPadding));
        }
        if (!BcStringUtil.isEmpty(bgColor)) {
            sb.append(" bgcolor=" + BcStringUtil.doubleQuotation(bgColor));
        }
        return this.tagStart(HtmlConstants.HtmlTag.table.name(), sb.toString(), true);
    }

    public String table_start(HtmlGlobalAttribute globalAttribute, String width, String height) throws Exception {
        return this.table_start(globalAttribute, width, height, -1, -1, -1, null);
    }

    public String table_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.table_start(globalAttribute, null, null);
    }

    public String table_start() throws Exception {
        HtmlGlobalAttribute globalAttribut = null;
        return this.table_start(globalAttribut, null, null);
    }

    public String table_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.table, true);
    }

    public String thead_start() throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.thead, true);
    }

    public String thead_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.thead, true);
    }

    public String tbody_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.tbody.name(), globalAttribute, true);
    }

    public String tbody_start() throws Exception {
        return this.tbody_start(null);
    }

    public String tbody_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.tbody, true);
    }

    public String tr_start(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.tagStart(HtmlConstants.HtmlTag.tr.name(), globalAttribute, true);
    }

    public String tr_start() throws Exception {
        return this.tr_start(null);
    }

    public String tr_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.tr, true);
    }

    public String th_td_common(String tagName, HtmlGlobalAttribute globalAttribute, int rowSpan, int colSpan, int hAlign, int vAlign, String width, String height, String bgColor) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(tagName);
        if (globalAttribute != null) {
            String globalAttributes = this.toGlobalAttributes(globalAttribute);
            BcStringUtil.appendCaseOfTestDataNotEmpty(sb, globalAttributes, String.valueOf(BcStringUtil.SPACE_STR) + globalAttributes);
        }
        if (rowSpan > 1) {
            sb.append(" rowspan=" + BcStringUtil.doubleQuotation(rowSpan));
        }
        if (colSpan > 1) {
            sb.append(" colspan=" + BcStringUtil.doubleQuotation(colSpan));
        }
        switch (hAlign) {
            case 0: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("center"));
                break;
            }
            case 4: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("right"));
                break;
            }
        }
        switch (vAlign) {
            case 1: {
                sb.append(" valign=" + BcStringUtil.doubleQuotation("top"));
                break;
            }
            case 3: {
                sb.append(" valign=" + BcStringUtil.doubleQuotation("bottom"));
                break;
            }
        }
        if (!BcStringUtil.isEmpty(width)) {
            sb.append(" width=" + BcStringUtil.doubleQuotation(width));
        }
        if (!BcStringUtil.isEmpty(height)) {
            sb.append(" height=" + BcStringUtil.doubleQuotation(height));
        }
        if (!BcStringUtil.isEmpty(bgColor)) {
            sb.append(" bgcolor=" + BcStringUtil.doubleQuotation(bgColor));
        }
        sb.append(">");
        return sb.toString();
    }

    public String th(HtmlGlobalAttribute globalAttribute, int rowSpan, int colSpan, int hAlign, int vAlign) throws Exception {
        return this.th_td_common(HtmlConstants.HtmlTag.th.name(), globalAttribute, rowSpan, colSpan, hAlign, vAlign, null, null, null);
    }

    public String th(int rowSpan, int colSpan, int hAlign, int vAlign, String clazz, String style) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        globalAttribute.style = style;
        return this.th(globalAttribute, rowSpan, colSpan, hAlign, vAlign);
    }

    public String th(int rowSpan, int colSpan, int hAlign, int vAlign, String clazz) throws Exception {
        return this.th(rowSpan, colSpan, hAlign, vAlign, clazz, null);
    }

    public String th(int rowSpan, int colSpan, String clazz) throws Exception {
        return this.th(rowSpan, colSpan, -1, -1, clazz, null);
    }

    public String th(String clazz) throws Exception {
        return this.th(-1, -1, -1, -1, clazz, null);
    }

    public String th_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.th, true);
    }

    public String tableCell(HtmlGlobalAttribute globalAttribute, int rowSpan, int colSpan, int hAlign, int vAlign, String width, String height, String bgColor) throws Exception {
        return this.th_td_common(HtmlConstants.HtmlTag.td.name(), globalAttribute, rowSpan, colSpan, hAlign, vAlign, width, height, bgColor);
    }

    public String tableCell(HtmlGlobalAttribute globalAttribute, int rowSpan, int colSpan) throws Exception {
        return this.tableCell(globalAttribute, rowSpan, colSpan, -1, -1, null, null, null);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign, String width, String height, String bgColor, String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = null;
        if (!BcStringUtil.isEmpty(clazz)) {
            globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = clazz;
        }
        return this.tableCell(globalAttribute, rowSpan, colSpan, hAlign, vAlign, width, height, bgColor);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign, String width, String height, String bgColor) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, width, height, bgColor, null);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign, String width, String height) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, width, height, null);
    }

    public String tableCell(int rowSpan, int colSpan, String width, String height, int hAlign, int vAlign) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, width, height, null);
    }

    public String tableCell(int rowSpan, int colSpan, String width, String height) throws Exception {
        return this.tableCell(rowSpan, colSpan, -1, -1, width, height, null, null);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign, int width, int height, String bgColor) throws Exception {
        String widthStr = null;
        if (width > 0) {
            widthStr = Integer.toString(width);
        }
        String heightStr = null;
        if (height > 0) {
            heightStr = Integer.toString(height);
        }
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, widthStr, heightStr, bgColor, null);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign, String clazz) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, null, null, null, clazz);
    }

    public String tableCell(int rowSpan, int colSpan, int hAlign, int vAlign) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, null, null, null);
    }

    public String tableCell(int rowSpan, int colSpan, String clazz) throws Exception {
        return this.tableCell(rowSpan, colSpan, -1, -1, null, null, null, clazz);
    }

    public String tableCell(String clazz) throws Exception {
        return this.tableCell(1, 1, clazz);
    }

    public String tableCell(int rowSpan, int colSpan) throws Exception {
        return this.tableCell(rowSpan, colSpan, -1, -1, null, null, null, null);
    }

    public String tableCell() throws Exception {
        return this.tableCell(1, 1);
    }

    public String tableCell(int rowSpan, int colSpan, MmdField mmdField) throws Exception {
        Object clazz = null;
        if (!(mmdField.dataClass.equals(Byte.class) || mmdField.dataClass.equals(Short.class) || mmdField.dataClass.equals(Integer.class) || mmdField.dataClass.equals(Long.class) || mmdField.dataClass.equals(Float.class) || mmdField.dataClass.equals(Double.class) || mmdField.dataClass.equals(BigDecimal.class))) {
            clazz = null;
        }
        return this.tableCell(rowSpan, colSpan, -1, -1, null, null, null, clazz);
    }

    public String tableCell(int rowSpan, int colSpan, String width, String height, int hAlign, int vAlign, String bgColor, String clazz) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, width, height, bgColor, clazz);
    }

    public String tableCell(int rowSpan, int colSpan, String width, String height, int hAlign, int vAlign, String bgColor) throws Exception {
        return this.tableCell(rowSpan, colSpan, hAlign, vAlign, width, height, bgColor, null);
    }

    public String td_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.td, true);
    }

    public String tfoot(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.tagStart(HtmlConstants.HtmlTag.tfoot.name(), globalAttribute, true);
    }

    public String tfoot_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.tfoot, true);
    }

    public String ul_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.ul, globalAttribute, true);
    }

    public String ul_start(String clazz, String id) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        globalAttribute.id = id;
        return this.ul_start(globalAttribute);
    }

    public String ul_start() throws Exception {
        return this.ul_start(null);
    }

    public String ul_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.ul, true);
    }

    public String ol_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.ol, globalAttribute, true);
    }

    public String ol_start(String clazz, String id) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        globalAttribute.id = id;
        return this.ol_start(globalAttribute);
    }

    public String ol_start() throws Exception {
        return this.ol_start(null);
    }

    public String ol_end() throws Exception {
        return this.tagEnd(HtmlConstants.HtmlTag.ol, true);
    }

    public String li_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.li, globalAttribute, true);
    }

    public String li_start(String clazz, String id) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        globalAttribute.id = id;
        return this.li_start(globalAttribute);
    }

    public String li_start() throws Exception {
        return this.li_start(null);
    }

    public String li_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.li, true);
    }

    public String dl_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.dl, globalAttribute, true);
    }

    public String dl_start(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.dl_start(globalAttribute);
    }

    public String dl_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.dl, true);
    }

    public String dt_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.dt, globalAttribute, false);
    }

    public String dt_start(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.dt_start(globalAttribute);
    }

    public String dt_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.dt, true);
    }

    public String dd_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.dd, globalAttribute, false);
    }

    public String dd_start(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.dd_start(globalAttribute);
    }

    public String dd_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.dd, true);
    }

    public String script_start(Collection<HtmlTagAttribute> tagAttributeCollection, boolean lineFeed) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.script, tagAttributeCollection, false);
    }

    public String script_start(boolean lineFeed) throws Exception {
        return this.script_start(null, lineFeed);
    }

    public String script_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.script, true);
    }

    public String script(String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.script_start(true));
        BcStringUtil.append(sb, script);
        sb.append(this.appLineSep());
        sb.append(this.script_end());
        return sb.toString();
    }

    public String toScriptSrcLinkTag(String src) throws Exception {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        tagAttributeList.add(new HtmlTagAttribute("type", BcMimeUtil.MimeType.application_javascript.value));
        if (!BcStringUtil.isEmpty(src)) {
            tagAttributeList.add(new HtmlTagAttribute("src", src));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.script_start(tagAttributeList, false));
        sb.append(this.script_end());
        return sb.toString();
    }

    public String image(HtmlGlobalAttribute globalAttribute, HtmlImageAttribute imageAttribute, String script) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(imageAttribute.src)) {
            tagAttributeList.add(new HtmlTagAttribute("src", imageAttribute.src));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.alt)) {
            tagAttributeList.add(new HtmlTagAttribute("alt", imageAttribute.alt));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.width)) {
            tagAttributeList.add(new HtmlTagAttribute("width", imageAttribute.width));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.height)) {
            tagAttributeList.add(new HtmlTagAttribute("height", imageAttribute.height));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.name)) {
            tagAttributeList.add(new HtmlTagAttribute("name", imageAttribute.name));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.mapName)) {
            tagAttributeList.add(new HtmlTagAttribute("usemap", "#" + imageAttribute.mapName));
        }
        if (imageAttribute.hspace > 0) {
            tagAttributeList.add(new HtmlTagAttribute("hspace", (Object)imageAttribute.hspace));
        }
        if (imageAttribute.vspace > 0) {
            tagAttributeList.add(new HtmlTagAttribute("vspace", (Object)imageAttribute.vspace));
        }
        if (!BcStringUtil.isEmpty(imageAttribute.border)) {
            tagAttributeList.add(new HtmlTagAttribute("border", imageAttribute.border));
        }
        switch (imageAttribute.align) {
            case 1: {
                tagAttributeList.add(new HtmlTagAttribute("align", "top"));
                break;
            }
            case 3: {
                tagAttributeList.add(new HtmlTagAttribute("align", "bottom"));
                break;
            }
            case 2: {
                tagAttributeList.add(new HtmlTagAttribute("align", "left"));
                break;
            }
            case 4: {
                tagAttributeList.add(new HtmlTagAttribute("align", "right"));
                break;
            }
            case 0: {
                tagAttributeList.add(new HtmlTagAttribute("align", "center"));
            }
        }
        if (!BcStringUtil.isEmpty(script)) {
            tagAttributeList.add(new HtmlTagAttribute(null, script));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.img.name(), tagAttributeList, true));
        return sb.toString();
    }

    public String image(String name, String src, String width, String height, int hspace, int vspace, String border, int align, String alt, String mapName, String script, String id, String clazz) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<img");
        if (!BcStringUtil.isEmpty(name)) {
            sb.append(" name=" + BcStringUtil.doubleQuotation(name));
        }
        if (!BcStringUtil.isEmpty(src)) {
            sb.append(" src=" + BcStringUtil.doubleQuotation(src));
        }
        if (!BcStringUtil.isEmpty(width)) {
            sb.append(" width=" + BcStringUtil.doubleQuotation(width));
        }
        if (!BcStringUtil.isEmpty(height)) {
            sb.append(" height=" + BcStringUtil.doubleQuotation(height));
        }
        if (hspace > 0) {
            sb.append(" hspace=" + BcStringUtil.doubleQuotation(hspace));
        }
        if (vspace > 0) {
            sb.append(" vspace=" + BcStringUtil.doubleQuotation(vspace));
        }
        if (!BcStringUtil.isEmpty(border)) {
            sb.append(" border=" + BcStringUtil.doubleQuotation(border));
        }
        if (!BcStringUtil.isEmpty(id)) {
            sb.append(" id=" + BcStringUtil.doubleQuotation(id));
        }
        if (!BcStringUtil.isEmpty(clazz)) {
            sb.append(" class=" + BcStringUtil.doubleQuotation(clazz));
        }
        switch (align) {
            case 1: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("top"));
                break;
            }
            case 3: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("bottom"));
                break;
            }
            case 2: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("left"));
                break;
            }
            case 4: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("right"));
                break;
            }
            case 0: {
                sb.append(" align=" + BcStringUtil.doubleQuotation("center"));
            }
        }
        if (!BcStringUtil.isEmpty(alt)) {
            sb.append(" alt=" + BcStringUtil.doubleQuotation(alt));
        }
        if (!BcStringUtil.isEmpty(mapName)) {
            sb.append(" usemap=" + BcStringUtil.doubleQuotation("#" + mapName));
        }
        if (!BcStringUtil.isEmpty(script)) {
            sb.append(" " + script);
        }
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String image(String name, String src, String width, String height, String alt, String mapName) throws Exception {
        return this.image(name, src, width, height, -1, -1, null, -1, alt, mapName, null, null, null);
    }

    public String image(String name, String src, String width, String height, String alt, String mapName, String id) throws Exception {
        return this.image(name, src, width, height, -1, -1, null, -1, alt, mapName, null, id, null);
    }

    public String image(String name, String src, String width, String height, String alt) throws Exception {
        return this.image(name, src, width, height, alt, null);
    }

    public String image(String src, String width, String height, String alt) throws Exception {
        return this.image(null, src, width, height, alt, null);
    }

    public String image(String name, String src, String alt) throws Exception {
        return this.image(name, src, null, null, alt, null);
    }

    public String image(String src, String alt) throws Exception {
        return this.image(null, src, null, null, alt, null);
    }

    public String imageWithScript(String name, String src, String alt, String script) throws Exception {
        return this.image(name, src, null, null, -1, -1, null, 2, alt, null, script, null, null);
    }

    public String imageWithScript(String name, String src, String alt, String script, String id) throws Exception {
        return this.image(name, src, null, null, -1, -1, null, 2, alt, null, script, id, null);
    }

    public String image_class(String src, String clazz) throws Exception {
        return this.image(null, src, null, null, -1, -1, null, 2, null, null, null, null, clazz);
    }

    public String canvas(HtmlGlobalAttribute globalAttribute) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.canvas, globalAttribute, false));
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.canvas, true));
        return sb.toString();
    }

    public String map(String name) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<map");
        sb.append(" name=" + BcStringUtil.doubleQuotation(name));
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String area(String coords, String href, String alt) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<area");
        sb.append(" shape=" + BcStringUtil.doubleQuotation("rect"));
        sb.append(" coords=" + BcStringUtil.doubleQuotation(coords));
        sb.append(" href=" + BcStringUtil.doubleQuotation(href));
        sb.append(" alt=" + BcStringUtil.doubleQuotation(alt));
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public StringBuilder basefont(int fontSize) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<basefont");
        sb.append(" size=" + fontSize);
        sb.append(">");
        return sb;
    }

    public String b_start() throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.b, false);
    }

    public String b_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.b, false);
    }

    public String b(String content) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.b_start());
        BcStringUtil.append(sb, content);
        sb.append(this.b_end());
        return sb.toString();
    }

    public String i_start(HtmlGlobalAttribute globalAttribute, boolean lineFeed) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.i, globalAttribute, lineFeed);
    }

    public String i_start() throws Exception {
        return this.i_start(null, false);
    }

    public String i_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.i, false);
    }

    public String font_start(int fontSize, int style, String fontFace, String color, String value) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (BcStringUtil.isEmpty(value)) {
            return sb.toString();
        }
        if ((style & 1) != 0) {
            sb.append(this.b_start());
        }
        if ((style & 2) != 0) {
            sb.append(this.i_start());
        }
        sb.append("<font");
        if (fontSize > 0) {
            sb.append(" size=" + BcStringUtil.doubleQuotation(fontSize));
        }
        if (!BcStringUtil.isEmpty(color)) {
            sb.append(" color=" + BcStringUtil.doubleQuotation(color));
        }
        if (!BcStringUtil.isEmpty(fontFace)) {
            sb.append(" face=" + BcStringUtil.doubleQuotation(fontFace));
        }
        sb.append(">");
        sb.append(HtmlUtil.encode(value));
        sb.append("</font>");
        if ((style & 2) != 0) {
            sb.append(this.i_end());
        }
        if ((style & 1) != 0) {
            sb.append(this.b_end());
        }
        return sb.toString();
    }

    public String font_start(String fontSize, int style, String fontFace, String color, String value) throws Exception {
        return this.font_start(BcNumberUtil.parseInt(fontSize, -1), style, fontFace, color, value);
    }

    public String font_start(String fontSize, String color, String fontFace) throws Exception {
        StringBuilder sb = new StringBuilder(40);
        sb.append("<font");
        if (!BcStringUtil.isEmpty(fontSize)) {
            sb.append(" size=" + BcStringUtil.doubleQuotation(fontSize));
        }
        if (!BcStringUtil.isEmpty(color)) {
            sb.append(" color=" + BcStringUtil.doubleQuotation(color));
        }
        if (!BcStringUtil.isEmpty(fontFace)) {
            sb.append(" face=" + BcStringUtil.doubleQuotation(fontFace));
        }
        sb.append(">");
        return sb.toString();
    }

    public String font_start(int fontSize, String color, String fontFace) throws Exception {
        return this.font_start(Integer.toString(fontSize), color, fontFace);
    }

    public String font_start(int fontSize) throws Exception {
        return this.font_start(Integer.toString(fontSize), null, null);
    }

    public String font_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.font, false);
    }

    public String font(String fontSize, String color, String fontFace, String value) throws Exception {
        StringBuilder sb = null;
        if (!BcStringUtil.isEmpty(value)) {
            sb = new StringBuilder(value.length() + 40);
            sb.append(this.font_start(fontSize, color, fontFace));
            sb.append(HtmlUtil.encode(value));
            sb.append(this.font_end());
        } else {
            sb = new StringBuilder("");
        }
        return sb.toString();
    }

    public String font(int fontSize, String color, String fontFace, String value) throws Exception {
        return this.font(Integer.toString(fontSize), color, fontFace, value);
    }

    public String refresh(int seconds, String url) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<meta");
        sb.append(" http-equiv=" + BcStringUtil.doubleQuotation("refresh"));
        String tmpStr = Integer.toString(seconds);
        if (!BcStringUtil.isEmpty(url)) {
            tmpStr = String.valueOf(tmpStr) + ";URL=" + url;
        }
        sb.append(" content=" + BcStringUtil.doubleQuotation(tmpStr));
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String refresh(int seconds) throws Exception {
        return this.refresh(seconds, null);
    }

    public StringBuilder monthSelectCombobox(String name, int month, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        ArrayList<BcPair<String, String>> optionList = new ArrayList<BcPair<String, String>>();
        int i = 0;
        while (i < 12) {
            String str = Integer.toString(i + 1);
            BcPair<String, String> pair = new BcPair<String, String>(str, str);
            optionList.add(pair);
            ++i;
        }
        sb.append(this.select(name, optionList, Integer.toString(month), script));
        return sb;
    }

    public StringBuilder monthSelectCombobox(String name, String month, String script) throws Exception {
        return this.monthSelectCombobox(name, BcNumberUtil.parseInteger(month), script);
    }

    public String numSelectCombobox(String name, int startValue, int diff, int count, int defaultValue, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        ArrayList<BcPair<String, String>> optionList = new ArrayList<BcPair<String, String>>();
        int i = 0;
        while (i < count) {
            String str = Integer.toString(startValue + diff * i);
            BcPair<String, String> pair = new BcPair<String, String>(str, str);
            optionList.add(pair);
            ++i;
        }
        sb.append(this.select(name, optionList, Integer.toString(defaultValue), script));
        return sb.toString();
    }

    public String docType(int docType) {
        StringBuilder sb = new StringBuilder();
        switch (docType) {
            case 2: {
                sb.append("<");
                sb.append("!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Frameset//EN\"");
                sb.append(" ");
                sb.append("\"http://www.w3.org/TR/REC-html40/frameset.dtd\"");
                sb.append(">");
                break;
            }
            default: {
                sb.append("<");
                sb.append("!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"");
                sb.append(">");
            }
        }
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String header(String title) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<html lang=\"ja\">");
        sb.append(this.appLineSep());
        sb.append("<head>");
        sb.append(this.appLineSep());
        sb.append("<meta HTTP-EQUIV=\"Content-Type\" content=\"text/html;charset=UTF-8\">");
        sb.append(this.appLineSep());
        sb.append("<meta HTTP-EQUIV=\"Content-Script-Type\" content=\"text/javascript\">");
        sb.append(this.appLineSep());
        sb.append("<meta HTTP-EQUIV=\"Content-Style-Type\" content=\"text/css\">");
        sb.append(this.appLineSep());
        sb.append("<title>");
        sb.append(HtmlUtil.encode(title));
        sb.append("</title>");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String frameSet(String rows, String cols, boolean hasFrmaeBoder, int border, int frameSpacing) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<frameset");
        HtmlUtil.appendAddQua(sb, " rows=", rows);
        HtmlUtil.appendAddQua(sb, " cols=", cols);
        if (hasFrmaeBoder) {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(1));
        } else {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(0));
        }
        if (border >= 0) {
            sb.append(" border=" + BcStringUtil.doubleQuotation(border));
        }
        if (frameSpacing >= 0) {
            sb.append(" framespacing=" + BcStringUtil.doubleQuotation(frameSpacing));
        }
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String frame(String name, String source, String para, boolean hasFrmaeBoder, int scrooling) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<frame");
        HtmlUtil.appendAddQua(sb, " name=", name);
        if (!BcStringUtil.isEmpty(source)) {
            sb.append(" src=\"" + source);
            if (para != null) {
                sb.append("?" + para);
            }
            sb.append("\"");
        }
        if (hasFrmaeBoder) {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(1));
        } else {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(0));
        }
        switch (scrooling) {
            case 1: {
                sb.append(" scrolling=" + BcStringUtil.doubleQuotation("yes"));
                break;
            }
            case 2: {
                sb.append(" scrolling=" + BcStringUtil.doubleQuotation("no"));
                break;
            }
        }
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String body(String bgColor, String fgColor, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<body");
        HtmlUtil.appendAddQua(sb, " bgcolor=", bgColor);
        HtmlUtil.appendAddQua(sb, " text=", fgColor);
        HtmlUtil.appendAddQua(sb, " ", script);
        sb.append(" leftMargin=\"0\" topMargin=\"0\"");
        sb.append(" marginHeight=\"0\" marginWcssIdth=\"0\"");
        sb.append(">");
        sb.append(this.appLineSep());
        return sb.toString();
    }

    public String body(String bgColor, String fgColor) throws Exception {
        return this.body(bgColor, fgColor, null);
    }

    public String br(boolean lineFeed) {
        return this.tagStart(HtmlConstants.HtmlTag.br, lineFeed);
    }

    public String br() {
        return this.br(true);
    }

    public String dialog_start(HtmlGlobalAttribute globalAttribute) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        return this.tagStart(HtmlConstants.HtmlTag.dialog.name(), tagAttributeList, true);
    }

    public String dialog_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.dialog, true);
    }

    public String center_start() {
        return this.tagStart(HtmlConstants.HtmlTag.center, false);
    }

    public String center_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.center, false);
    }

    public String center(String content) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.center_start());
        BcStringUtil.append(sb, content);
        sb.append(this.center_end());
        return sb.toString();
    }

    public List<HtmlTagAttribute> buttonAttributeList(HtmlConstants.HtmlButtonType buttonType, String name, Object value, boolean disabled, String onclick) throws Exception {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        if (buttonType != null) {
            tagAttributeList.add(new HtmlTagAttribute("type", buttonType.name()));
        }
        if (!BcStringUtil.isEmpty(name)) {
            tagAttributeList.add(new HtmlTagAttribute("name", name));
        }
        if (value != null) {
            tagAttributeList.add(new HtmlTagAttribute("value", value));
        }
        if (disabled) {
            tagAttributeList.add(new HtmlTagAttribute("disabled", (Object)null));
        }
        if (!BcStringUtil.isEmpty(onclick)) {
            tagAttributeList.add(new HtmlTagAttribute("onclick", onclick));
        }
        return tagAttributeList;
    }

    public String button_start(HtmlGlobalAttribute globalAttribute, HtmlConstants.HtmlButtonType buttonType, String name, Object value, boolean disabled, String onclick) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        tagAttributeList.addAll(this.buttonAttributeList(buttonType, name, value, disabled, onclick));
        return this.tagStart(HtmlConstants.HtmlTag.button.name(), tagAttributeList, true);
    }

    public String button_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.button, true);
    }

    public String hr(HtmlGlobalAttribute globalAttribute) throws Exception {
        return this.tagStart(HtmlConstants.HtmlTag.hr, globalAttribute, true);
    }

    public String hr(String clazz) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = clazz;
        return this.hr(globalAttribute);
    }

    public String hr() throws Exception {
        HtmlGlobalAttribute globalAttribute = null;
        return this.hr(globalAttribute);
    }

    public StringBuilder createHiddenTags(Map<String, Object> parameterMap) throws Exception {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = parameterMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            sb.append(this.hidden(entry.getKey(), entry.getValue()));
        }
        return sb;
    }

    public String appendClass(String base, String add) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, base);
        if (!BcStringUtil.isEmpty(add)) {
            sb.append(' ');
            sb.append(add);
        }
        return sb.toString();
    }

    public String datalist(String id, Collection<String> optionCollection) throws Exception {
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = id;
        StringBuilder sb = new StringBuilder(this.tagStart(HtmlConstants.HtmlTag.datalist, globalAttribute, true));
        for (CharSequence charSequence : optionCollection) {
            HtmlTagAttribute tagAttribute = new HtmlTagAttribute("value", charSequence);
            sb.append(' ');
            sb.append(this.tagStart(HtmlConstants.HtmlTag.option.name(), false, tagAttribute));
            sb.append(this.appLineSep());
        }
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.datalist, true));
        return sb.toString();
    }

    public static String toOnOf\uff46(boolean bool) {
        if (bool) {
            return on;
        }
        return off;
    }

    public String link(String rel, String href) throws Exception {
        ArrayList<HtmlTagAttribute> tagAttributeList = new ArrayList<HtmlTagAttribute>();
        tagAttributeList.add(new HtmlTagAttribute("rel", rel));
        tagAttributeList.add(new HtmlTagAttribute("href", href));
        return this.tagStart(HtmlConstants.HtmlTag.link, tagAttributeList, true);
    }

    public String link_stylesheet(String href) throws Exception {
        return this.link("stylesheet", href);
    }

    public String inlineFrame(HtmlGlobalAttribute globalAttribute, String source, String para, int width, int height, boolean hasFrmaeBoder, int scrooling) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.iframe, globalAttribute, false));
        if (!BcStringUtil.isEmpty(source)) {
            sb.append(" src=\"" + source);
            if (para != null) {
                sb.append("?" + para);
            }
            sb.append("\"");
        }
        if (width > 0) {
            sb.append(" width=" + BcStringUtil.doubleQuotation(width));
        }
        if (height > 0) {
            sb.append(" height=" + BcStringUtil.doubleQuotation(height));
        }
        if (hasFrmaeBoder) {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(1));
        } else {
            sb.append(" frmaeborder=" + BcStringUtil.doubleQuotation(0));
        }
        switch (scrooling) {
            case 1: {
                sb.append(" scrolling=" + BcStringUtil.doubleQuotation("yes"));
                break;
            }
            case 2: {
                sb.append(" scrolling=" + BcStringUtil.doubleQuotation("no"));
                break;
            }
        }
        sb.append(">");
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.iframe, true));
        return sb.toString();
    }

    public String svg_start(HtmlGlobalAttribute globalAttribute, String viewBox) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(viewBox)) {
            tagAttributeList.add(new HtmlTagAttribute("viewBox", viewBox));
        }
        return this.tagStart(HtmlConstants.HtmlTag.svg, tagAttributeList, true).toString();
    }

    public String svg_end() {
        return this.tagEnd(HtmlConstants.HtmlTag.svg, true);
    }

    public String path(HtmlGlobalAttribute globalAttribute, String fill, String d) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (!BcStringUtil.isEmpty(fill)) {
            tagAttributeList.add(new HtmlTagAttribute("fill", fill));
        }
        if (!BcStringUtil.isEmpty(d)) {
            tagAttributeList.add(new HtmlTagAttribute("d", d));
        }
        return this.tagStart(HtmlConstants.HtmlTag.path, tagAttributeList, true).toString();
    }

    public String space(int cnt) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < cnt) {
            sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
            ++i;
        }
        return sb.toString();
    }

    public String progress(HtmlGlobalAttribute globalAttribute, double max, double value) throws Exception {
        List<HtmlTagAttribute> tagAttributeList = this.toAttributeList(globalAttribute);
        if (max > 0.0) {
            tagAttributeList.add(new HtmlTagAttribute("max", (Object)max));
        }
        if (value > 0.0) {
            tagAttributeList.add(new HtmlTagAttribute("value", (Object)value));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagStart(HtmlConstants.HtmlTag.progress, tagAttributeList, false));
        sb.append(this.tagEnd(HtmlConstants.HtmlTag.progress, true));
        return sb.toString();
    }

    private static final class SingletonHolder {
        private static final HtmlBuilder instance = new HtmlBuilder();

        private SingletonHolder() {
        }
    }
}

